package com.hikcreate.update_hbase.dao;

import com.hikcreate.update_hbase.annotation.DBSource;
import com.hikcreate.update_hbase.entity.AcdAll;
import com.hikcreate.update_hbase.entity.AcdHuman;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public interface AcdMapper {

    @DBSource(name = "bokang")
    List<AcdAll> getFileAcdPastDay(@Param("past") int past);

    @DBSource(name = "bokang")
    List<AcdAll> getDutySimpleAcdPastDay(@Param("past") int past);

    @DBSource(name = "bokang")
    List<AcdAll> getQuickAcdPastDay(@Param("past") int past);

    @DBSource(name = "bokang")
    List<AcdAll> getIncreAcd(@Param("GXTIME") String GXTIME);

    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select sgbh sgbh,xzqh xzqh,djbh djbh,'null' kskcsj_1,'null' jskcsj_1,xq xq,sgfssj sgfssj,lh lh,lm lm,gls gls,ms ms,'null' qdms_1,jdwz jdwz,sgdd sgdd,'null' zhdmwz_1,'null' zyglss_1,'null' dlaqsx_1,'null' jtxhfs_1,'null' fhsslx_1,'null' dlwlgl_1,'null' lmzk_1,lbqk lbqk,'null' lmjg_1,'null' lkldlx_1,'null' dlxx_1,dllx dllx,'null' kcr1_1,'null' kcr2_1,'null' bar1_1,'null' bar2_1,'null' swrs_1,'null' swrsq_1,'null' swrs24_1,'null' ssrs24_1,'null' swrs3_1,'null' ssrs3_1,'null' swrs7_1,'null' ssrs7_1,'null' swrs30_1,'null' ssrs30_1,'null' szrs_1,'null' zsrs_1,'null' qsrs_1,'null' ssrs_1,'null' jdcsl_1,'null' fjdcsl_1,'null' xrsl_1,'null' xsglbm_1,'null' xsbadw_1,'null' xsbar_1,'null' tpzs_1,'null' xctzs_1,'null' xczpzs_1,zjccss zjccss,'null' sglx_1,lwsglx lwsglx,'null' ccyyfl_1,rdyyfl rdyyfl,'null' sgccyy_1,sgrdyy sgrdyy,'null' jyaq_1,tq tq,'null' njd_1,xc xc,swsg swsg,sgxt sgxt,'null' sfty_1,cljsg cljsg,dcsg dcsg,pzfs pzfs,'null' tysgzp_1,'null' tyzpsj_1,'null' dx_1,'null' zmtj_1,tjr1 tjr1,'null' tjr2_1,'null' yzwxp_1,'null' yzwxphg_1,cclrsj cclrsj,jllx jllx,scsjd scsjd,jbr jbr,'null' tjsj_1,gxsj gxsj,sszd sszd,glxzdj glxzdj,dah dah,'null' jnh_1,'null' sxxz_1,sb sb,tjsgbh tjsgbh,glbm glbm,'null' ylzd1_1,'null' ylzd2_1,'null' ylzd3_1,'null' ylzd4_1,'null' ylzd5_1,dzzb dzzb,'null' tdyl1_1,'null' tdyl2_1,'null' tdyl3_1,'null' tdyl4_1,'null' tdyl5_1,'null' tdyl6_1,'null' tdyl7_1,'null' tdyl8_1,'null' tdyl9_1,'null' tdyl10_1,'null' balxfs_1,badw badw,'null' xyxdm_1,jyw jyw,'null' sfecsg_1,'null' sfdxsg_1,'null' dlaqyhdj_1,'null' dsrzs_1,'null' fsjg_1,'null' ffjg_1,'null' sdsgdscwz_1,'null' hlzt_1,ssrs ssrs_2,wsbh wsbh_2,sgss sgss_2,zrtjjg zrtjjg_2,jar1 jar1_2,jar2 jar2_2,jafs jafs_2,tjfs tjfs_2,'null' driver1infoid_3,'null' driver2infoid_3,'null' finishtime_3,'null' accepttime_3,'null' userid_3,'null' status_3,'null' driver1fault_3,'null' driver2fault_3,'null' driver1responsibility_3,'null' driver2responsibility_3,'null' driver3infoid_3,'null' driver3fault_3,'null' driver3responsibility_3,'null' recordtype_3,'null' customid_3,'null' kcbh_3,'null' serialnumber_3,'null' kccxm_3,'null' handlestatus_3,'null' username_3,'null' zrpduserid_3,'null' zrpdusername_3,'null' modifydate_3,'null' modifyusername_3,'null' modifyuserid_3,'null' driver1pzbw_3,'null' driver2pzbw_3,'null' driver3pzbw_3,'null' addrtype_3,'null' longitude_3,'null' latitude_3,'null' caseyjstatus_3,'null' caseyjreason_3,'2' data_source,concat('2#',sgbh) esid  from ZCKJ.VM_ACD_DUTYSIMPLE_A where GXSJ<![CDATA[ > ]]>to_date(#{GXTIME}, 'YYYY-MM-DD HH24:MI:SS') order by GXSJ desc",
            "</script>"
    })
    List<AcdAll> getIncreDutySimpleAcd(@Param("GXTIME") String updateTime);

    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select accidentinfoid sgbh,'null' xzqh,'null' djbh,'null' kskcsj_1,'null' jskcsj_1,'null' xq,accidenttime sgfssj,'null' lh,'null' lm,'null' gls,'null' ms,'null' qdms_1,'null' jdwz,accidentaddr sgdd,'null' zhdmwz_1,'null' zyglss_1,'null' dlaqsx_1,'null' jtxhfs_1,'null' fhsslx_1,'null' dlwlgl_1,'null' lmzk_1,'null' lbqk,'null' lmjg_1,'null' lkldlx_1,'null' dlxx_1,'null' dllx,'null' kcr1_1,'null' kcr2_1,'null' bar1_1,'null' bar2_1,'null' swrs_1,'null' swrsq_1,'null' swrs24_1,'null' ssrs24_1,'null' swrs3_1,'null' ssrs3_1,'null' swrs7_1,'null' ssrs7_1,'null' swrs30_1,'null' ssrs30_1,'null' szrs_1,'null' zsrs_1,'null' qsrs_1,'null' ssrs_1,'null' jdcsl_1,'null' fjdcsl_1,'null' xrsl_1,'null' xsglbm_1,'null' xsbadw_1,'null' xsbar_1,'null' tpzs_1,'null' xctzs_1,'null' xczpzs_1,'null' zjccss,'null' sglx_1,'null' lwsglx,'null' ccyyfl_1,'null' rdyyfl,'null' sgccyy_1,'null' sgrdyy,'null' jyaq_1,weather tq,'null' njd_1,'null' xc,'null' swsg,'null' sgxt,'null' sfty_1,'null' cljsg,'null' dcsg,'null' pzfs,'null' tysgzp_1,'null' tyzpsj_1,'null' dx_1,'null' zmtj_1,'null' tjr1,'null' tjr2_1,'null' yzwxp_1,'null' yzwxphg_1,'null' cclrsj,'null' jllx,'null' scsjd,'null' jbr,'null' tjsj_1,finishtime gxsj,'null' sszd,'null' glxzdj,'null' dah,'null' jnh_1,'null' sxxz_1,'null' sb,'null' tjsgbh,'null' glbm,'null' ylzd1_1,'null' ylzd2_1,'null' ylzd3_1,'null' ylzd4_1,'null' ylzd5_1,'null' dzzb,'null' tdyl1_1,'null' tdyl2_1,'null' tdyl3_1,'null' tdyl4_1,'null' tdyl5_1,'null' tdyl6_1,'null' tdyl7_1,'null' tdyl8_1,'null' tdyl9_1,'null' tdyl10_1,'null' balxfs_1,'null' badw,'null' xyxdm_1,'null' jyw,'null' sfecsg_1,'null' sfdxsg_1,'null' dlaqyhdj_1,'null' dsrzs_1,'null' fsjg_1,'null' ffjg_1,'null' sdsgdscwz_1,'null' hlzt_1,'null' ssrs_2,'null' wsbh_2,'null' sgss_2,'null' zrtjjg_2,'null' jar1_2,'null' jar2_2,'null' jafs_2,'null' tjfs_2,driver1infoid driver1infoid_3,driver2infoid driver2infoid_3,finishtime finishtime_3,accepttime accepttime_3,userid userid_3,status status_3,driver1fault driver1fault_3,driver2fault driver2fault_3,driver1responsibility driver1responsibility_3,driver2responsibility driver2responsibility_3,driver3infoid driver3infoid_3,driver3fault driver3fault_3,driver3responsibility driver3responsibility_3,recordtype recordtype_3,customid customid_3,kcbh kcbh_3,serialnumber serialnumber_3,kccxm kccxm_3,handlestatus handlestatus_3,username username_3,zrpduserid zrpduserid_3,zrpdusername zrpdusername_3,modifydate modifydate_3,modifyusername modifyusername_3,modifyuserid modifyuserid_3,driver1pzbw driver1pzbw_3,driver2pzbw driver2pzbw_3,driver3pzbw driver3pzbw_3,addrtype addrtype_3,longitude longitude_3,latitude latitude_3,caseyjstatus caseyjstatus_3,caseyjreason caseyjreason_3,'3' data_source,concat('3#',accidentinfoid) esid  from ZCKJ.VM_QUICK_ACCIDENTINFO where FINISHTIME<![CDATA[ > ]]>to_date(#{GXTIME}, 'YYYY-MM-DD HH24:MI:SS') order by FINISHTIME desc",
            "</script>"
    })
    List<AcdAll> getIncreQuickAcd(@Param("GXTIME") String updateTime);

    @DBSource(name = "bokang")
    List<AcdHuman> getIncreAcdHuman(@Param("past")int past);

    @DBSource(name = "bokang")
    List<AcdHuman> getIncreAcdDutySimpleHuman(@Param("past") int past);

    @DBSource(name = "bokang")
    List<AcdHuman> getIncreAcdQuickHuman(@Param("past") int past);

    @DBSource(name = "bokang")
    List<AcdHuman> getIncreAcdHuman20Min(@Param("GXTIME") String GXTIME);
}
