package com.hikcreate.update_hbase.dao;

import com.hikcreate.update_hbase.annotation.DBSource;
import com.hikcreate.update_hbase.entity.Driver;
import com.hikcreate.update_hbase.entity.Vehicle;
import com.hikcreate.update_hbase.entity.Vio;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public interface BokanMapper {

    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select * from zckj.VEHICLE_GY where GXRQ is not null and GXRQ<![CDATA[ > ]]>to_date(#{GXTIME}, 'YYYY-MM-DD HH24:MI:SS') order by GXRQ desc",
            "</script>"
    })
    List<Vehicle> getIncrementVehicle(@Param("GXTIME") String updateTime);

    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select a.*,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0206' and DMZ=a.JZQX and ROWNUM=1) jzqx_value,regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(ZT,'A','正常 '),'B','超分 '),'C','转出 '),'D','暂扣 '),'E','撤销 '),'F','吊销 '),'G','注销 '),'H','违法未处理 '),'I','事故未处理 '),'J','停止使用 '),'K','扣押 '),'L','锁定 '),'M','逾期未换证 '),'N','延期换证 '),'P','延期体检 '),'R','注销可恢复 '),'S','逾期未审验 '),'T','延期审验 '),'U','扣留 ') zt_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0002' and DMZ=a.LY  and ROWNUM=1) ly_value,(select sc.jxmc from ZCKJ.VM_JG_EXAM_SCHOOLINFO sc where sc.JXDM=a.JXMC  and ROWNUM=1) jxmc_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.XZQH  and ROWNUM=1) xzqh_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0051' and DMZ=a.XZQJ  and ROWNUM=1) xzqj_value,(select BMMC from ZCKJ.VM_FRM_DEPARTMENT_CODE depart where depart.GLBM=a.GLBM  and ROWNUM=1) glbm_value,regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(xgzl,'A','身份证明 '),'B','机动车驾驶证申请表 '),'C','身体条件证明 '),'D','原驾驶证 '),'E','复员转业退伍证明 '),'F','驾驶证中文翻译文本 '),'G','居住、暂住证明 '),'H','准考证明 '),'I','科目一考试成绩表 '),'J','科目二考试成绩表 '),'K','科目三考试成绩表 '),'L','驾校培训证明 '),'N','驾证注销证明 '),'P','裁决文件 '),'Q','代理人身份证明 '),'R','身份证号码变更证明 '),'S','接受教育凭证 '),'T','机动车驾驶人身体情况申报表 '),'U','从业单位出具的证明 '),'V','县级公安机关出具的无犯罪、吸毒行为记录证明原件 '),'W','内地居民往来港澳通行证 '),'X','大陆居民往来台湾通行证 '),'Y','军车驾驶员基本信息登记表 '),'Z','其它材料 ') xgzl_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='2019' and DMZ=a.SFZMMC  and ROWNUM=1) sfzmmc_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0211' and DMZ=a.HMCD  and ROWNUM=1) hmcd_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0035' and DMZ=a.XB  and ROWNUM=1) xb_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0031' and DMZ=a.GJ  and ROWNUM=1) gj_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.djzsxzqh  and ROWNUM=1) djzsxzqh_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.lxzsxzqh  and ROWNUM=1) lxzsxzqh_value from zckj.DRIVINGLICENSE_GY a where GXSJ is not null and GXSJ<![CDATA[ > ]]>to_date(#{GXTIME}, 'YYYY-MM-DD HH24:MI:SS') order by GXSJ desc",
            "</script>"
    })
    List<Driver> getIncrementDriver(@Param("GXTIME") String updateTime);

    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select a.*,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0206' and DMZ=a.JZQX and ROWNUM=1) jzqx_value,regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(ZT,'A','正常 '),'B','超分 '),'C','转出 '),'D','暂扣 '),'E','撤销 '),'F','吊销 '),'G','注销 '),'H','违法未处理 '),'I','事故未处理 '),'J','停止使用 '),'K','扣押 '),'L','锁定 '),'M','逾期未换证 '),'N','延期换证 '),'P','延期体检 '),'R','注销可恢复 '),'S','逾期未审验 '),'T','延期审验 '),'U','扣留 ') zt_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0002' and DMZ=a.LY  and ROWNUM=1) ly_value,(select sc.jxmc from ZCKJ.VM_JG_EXAM_SCHOOLINFO sc where sc.JXDM=a.JXMC  and ROWNUM=1) jxmc_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.XZQH  and ROWNUM=1) xzqh_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0051' and DMZ=a.XZQJ  and ROWNUM=1) xzqj_value,(select BMMC from ZCKJ.VM_FRM_DEPARTMENT_CODE depart where depart.GLBM=a.GLBM  and ROWNUM=1) glbm_value,regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(xgzl,'A','身份证明 '),'B','机动车驾驶证申请表 '),'C','身体条件证明 '),'D','原驾驶证 '),'E','复员转业退伍证明 '),'F','驾驶证中文翻译文本 '),'G','居住、暂住证明 '),'H','准考证明 '),'I','科目一考试成绩表 '),'J','科目二考试成绩表 '),'K','科目三考试成绩表 '),'L','驾校培训证明 '),'N','驾证注销证明 '),'P','裁决文件 '),'Q','代理人身份证明 '),'R','身份证号码变更证明 '),'S','接受教育凭证 '),'T','机动车驾驶人身体情况申报表 '),'U','从业单位出具的证明 '),'V','县级公安机关出具的无犯罪、吸毒行为记录证明原件 '),'W','内地居民往来港澳通行证 '),'X','大陆居民往来台湾通行证 '),'Y','军车驾驶员基本信息登记表 '),'Z','其它材料 ') xgzl_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='2019' and DMZ=a.SFZMMC  and ROWNUM=1) sfzmmc_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0211' and DMZ=a.HMCD  and ROWNUM=1) hmcd_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0035' and DMZ=a.XB  and ROWNUM=1) xb_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0031' and DMZ=a.GJ  and ROWNUM=1) gj_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.djzsxzqh  and ROWNUM=1) djzsxzqh_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.lxzsxzqh  and ROWNUM=1) lxzsxzqh_value from zckj.VM_DRIVINGLICENSE_GY a where GXSJ is not null and to_char(GXSJ,'YYYY-MM')<![CDATA[ = ]]>#{month} order by GXSJ desc",
            "</script>"
    })
    List<Driver> insertDriver2HbaseByMonth(@Param("month") String month);

    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select wfbh , jdslb , jdsbh , wsjyw , 'null' , 'null' , 'null' , fzjg , 'null' , dsr , zsxzqh , zsxxdz , dh , lxfs , clfl , hpzl , hphm , jdcsyr , syxz , jtfs , substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) wfsj, xzqh , dllx , glxzdj , wfdd , lddm , ddms , ddjdwz , wfdz , wfxw , 'null' , fkje , scz , bzz , 'null' , zqmj , jkfs , 'null' , 'null' , cljg , cljgmc , 'null' , clsj , jkbj , jkrq , pzbh , 'null' , jllx , lrr , lrsj , 'null' , 'null' , 'null' , cldxbj , 'null' , zdjlbj , 'null' , xrms , dkbj , 'null' , zdbj , jsjg , fsjg , gxsj , bz , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , ylzz1 , ylzz2 , ylzz3 , ylzz4 , ylzz5 , ylzz6 , ylzz7 , ylzz8 , cjfs , 'null' , 'null' , 'null' , 'null' , 'null' , clyt , xcfw , dzzb , 'null' , 'null' , 'null' , ylzz11 , ylzz12 , ylzz13 , ylzz14 , ylzz15 , ylzz16 , ylzz17 , ylzz18 , xh , cjjg , cjjgmc , fdjh , clsbdh , csys , clpp , tzsh , tzbj , tzrq , clbj , qzclbj , jbr , ydclbj , spdz , sbbh,HPHM || '#' || HPZL || '#' || substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) || '#' || WFXW || '#' || WFDD esid,HPHM || '#' || HPZL || '#' || substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) || '#' || WFXW || '#' || WFDD id  from ZCKJ.VIO_SURVEIL where GXSJ is not null and GXSJ<![CDATA[ > ]]>to_date(#{GXTIME}, 'YYYY-MM-DD HH24:MI:SS') order by GXSJ desc",
            "</script>"
    })
    List<Vio>  getIncrementVioBySurveil(@Param("GXTIME") String updateTime);

    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select wfbh , jdslb , jdsbh , wsjyw , ryfl , jszh , dabh , fzjg , zjcx , dsr , zsxzqh , zsxxdz , dh , lxfs , clfl , hpzl , hphm , jdcsyr , syxz , jtfs , substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) wfsj, xzqh , dllx , glxzdj , wfdd , lddm , ddms , ddjdwz , wfdz , wfxw , wfjfs , fkje , scz , bzz , znj , zqmj , jkfs , fxjg , fxjgmc , cljg , cljgmc , cfzl , clsj , jkbj , jkrq , pzbh , jsjqbj , jllx , lrr , lrsj , jbr1 , jbr2 , sgdj , cldxbj , jdccldxbj , zdjlbj , xxly , xrms , dkbj , jmznjbj , zdbj , jsjg , fsjg , gxsj , bz , ywjyw , zjmc , cclzrq , nl , xb , hcbj , jd , wd , ylzz1 , ylzz2 , ylzz3 , ylzz4 , ylzz5 , ylzz6 , ylzz7 , ylzz8 , cjfs , wfsj1 , wfdd1 , lddm1 , ddms1 , jsrxz , clyt , xcfw , dzzb , sfzdry , xysfzmhm , xyxm , ylzz11 , ylzz12 , ylzz13 , ylzz14 , ylzz15 , ylzz16 , ylzz17 , ylzz18 , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , '1' , 'null' , 'null' , 'null' , 'null' , 'null',HPHM || '#' || HPZL || '#' || substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) || '#' || WFXW || '#' || WFDD esid,HPHM || '#' || HPZL || '#' || substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) || '#' || WFXW || '#' || WFDD id   from ZCKJ.VIO_VIOLATION where GXSJ is not null and GXSJ<![CDATA[ > ]]>to_date(#{GXTIME}, 'YYYY-MM-DD HH24:MI:SS') order by GXSJ desc",
            "</script>"
    })
    List<Vio>  getIncrementVioByViolation(@Param("GXTIME") String updateTime);


    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select wfbh , jdslb , jdsbh , wsjyw , ryfl , jszh , dabh , fzjg , zjcx , dsr , zsxzqh , zsxxdz , dh , lxfs , clfl , hpzl , hphm , jdcsyr , syxz , jtfs , substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) wfsj, xzqh , dllx , glxzdj , wfdd , lddm , ddms , ddjdwz , wfdz , wfxw , wfjfs , fkje , scz , bzz , znj , zqmj , jkfs , fxjg , fxjgmc , cljg , cljgmc , cfzl , clsj , jkbj , jkrq , pzbh , jsjqbj , jllx , lrr , lrsj , jbr1 , jbr2 , sgdj , cldxbj , jdccldxbj , zdjlbj , xxly , xrms , dkbj , jmznjbj , zdbj , jsjg , fsjg , gxsj , bz , ywjyw , zjmc , cclzrq , nl , xb , hcbj , jd , wd , ylzz1 , ylzz2 , ylzz3 , ylzz4 , ylzz5 , ylzz6 , ylzz7 , ylzz8 , cjfs , wfsj1 , wfdd1 , lddm1 , ddms1 , jsrxz , clyt , xcfw , dzzb , sfzdry , xysfzmhm , xyxm , ylzz11 , ylzz12 , ylzz13 , ylzz14 , ylzz15 , ylzz16 , ylzz17 , ylzz18 , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , '1' , 'null' , 'null' , 'null' , 'null' , 'null',HPHM || '#' || HPZL || '#' || substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) || '#' || WFXW || '#' || WFDD esid,HPHM || '#' || HPZL || '#' || substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) || '#' || WFXW || '#' || WFDD id    from ZCKJ.VM_VIO_VIOLATION where GXSJ is not null and GXSJ<![CDATA[ >= ]]>to_date(#{start}, 'YYYY-MM-DD HH24:MI:SS') and GXSJ<![CDATA[ < ]]>to_date(#{end}, 'YYYY-MM-DD HH24:MI:SS')",
            "</script>"
    })
    List<Vio> getIncreVio(@Param("start")String start,@Param("end") String end);

    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select wfbh , jdslb , jdsbh , wsjyw , 'null' , 'null' , 'null' , fzjg , 'null' , dsr , zsxzqh , zsxxdz , dh , lxfs , clfl , hpzl , hphm , jdcsyr , syxz , jtfs , substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) wfsj, xzqh , dllx , glxzdj , wfdd , lddm , ddms , ddjdwz , wfdz , wfxw , 'null' , fkje , scz , bzz , 'null' , zqmj , jkfs , 'null' , 'null' , cljg , cljgmc , 'null' , clsj , jkbj , jkrq , pzbh , 'null' , jllx , lrr , lrsj , 'null' , 'null' , 'null' , cldxbj , 'null' , zdjlbj , 'null' , xrms , dkbj , 'null' , zdbj , jsjg , fsjg , gxsj , bz , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , ylzz1 , ylzz2 , ylzz3 , ylzz4 , ylzz5 , ylzz6 , ylzz7 , ylzz8 , cjfs , 'null' , 'null' , 'null' , 'null' , 'null' , clyt , xcfw , dzzb , 'null' , 'null' , 'null' , ylzz11 , ylzz12 , ylzz13 , ylzz14 , ylzz15 , ylzz16 , ylzz17 , ylzz18 , xh , cjjg , cjjgmc , fdjh , clsbdh , csys , clpp , tzsh , tzbj , tzrq , clbj , qzclbj , jbr , ydclbj , spdz , sbbh,HPHM || '#' || HPZL || '#' || substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) || '#' || WFXW || '#' || WFDD esid,HPHM || '#' || HPZL || '#' || substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) || '#' || WFXW || '#' || WFDD id    from ZCKJ.VM_VIO_SURVEIL where GXSJ is not null and GXSJ<![CDATA[ >= ]]>to_date(#{start}, 'YYYY-MM-DD HH24:MI:SS') and GXSJ<![CDATA[ < ]]>to_date(#{end}, 'YYYY-MM-DD HH24:MI:SS')",
            "</script>"
    })
    List<Vio> getIncreSurveil(@Param("start") String start, @Param("end") String end);


    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select wfbh , jdslb , jdsbh , wsjyw , ryfl , jszh , dabh , fzjg , zjcx , dsr , zsxzqh , zsxxdz , dh , lxfs , clfl , hpzl , hphm , jdcsyr , syxz , jtfs , substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) wfsj, xzqh , dllx , glxzdj , wfdd , lddm , ddms , ddjdwz , wfdz , wfxw , wfjfs , fkje , scz , bzz , znj , zqmj , jkfs , fxjg , fxjgmc , cljg , cljgmc , cfzl , clsj , jkbj , jkrq , pzbh , jsjqbj , jllx , lrr , lrsj , jbr1 , jbr2 , sgdj , cldxbj , jdccldxbj , zdjlbj , xxly , xrms , dkbj , jmznjbj , zdbj , jsjg , fsjg , gxsj , bz , ywjyw , zjmc , cclzrq , nl , xb , hcbj , jd , wd , ylzz1 , ylzz2 , ylzz3 , ylzz4 , ylzz5 , ylzz6 , ylzz7 , ylzz8 , cjfs , wfsj1 , wfdd1 , lddm1 , ddms1 , jsrxz , clyt , xcfw , dzzb , sfzdry , xysfzmhm , xyxm , ylzz11 , ylzz12 , ylzz13 , ylzz14 , ylzz15 , ylzz16 , ylzz17 , ylzz18 , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , '1' , 'null' , 'null' , 'null' , 'null' , 'null',HPHM || '#' || HPZL || '#' || substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) || '#' || WFXW || '#' || WFDD esid,HPHM || '#' || HPZL || '#' || substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) || '#' || WFXW || '#' || WFDD id  from (select a.* from(select * from ZCKJ.VM_VIO_VIOLATION  where GXSJ is not null and GXSJ<![CDATA[ >= ]]>to_date(#{start}, 'YYYY-MM-DD HH24:MI:SS') and GXSJ<![CDATA[ < ]]>to_date(#{end}, 'YYYY-MM-DD HH24:MI:SS')) a left outer join (select WFBH from ZCKJ.VM_VIO_VIOLATION_DEL where GXSJ<![CDATA[ >= ]]>sysdate-30)b  on a.WFBH=b.WFBH where b.WFBH is null) tab",
            "</script>"
    })
    List<Vio> getIncreVioVm(@Param("start") String start, @Param("end") String end);

    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select wfbh , jdslb , jdsbh , wsjyw , 'null' , 'null' , 'null' , fzjg , 'null' , dsr , zsxzqh , zsxxdz , dh , lxfs , clfl , hpzl , hphm , jdcsyr , syxz , jtfs , substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) wfsj, xzqh , dllx , glxzdj , wfdd , lddm , ddms , ddjdwz , wfdz , wfxw , 'null' , fkje , scz , bzz , 'null' , zqmj , jkfs , 'null' , 'null' , cljg , cljgmc , 'null' , clsj , jkbj , jkrq , pzbh , 'null' , jllx , lrr , lrsj , 'null' , 'null' , 'null' , cldxbj , 'null' , zdjlbj , 'null' , xrms , dkbj , 'null' , zdbj , jsjg , fsjg , gxsj , bz , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , 'null' , ylzz1 , ylzz2 , ylzz3 , ylzz4 , ylzz5 , ylzz6 , ylzz7 , ylzz8 , cjfs , 'null' , 'null' , 'null' , 'null' , 'null' , clyt , xcfw , dzzb , 'null' , 'null' , 'null' , ylzz11 , ylzz12 , ylzz13 , ylzz14 , ylzz15 , ylzz16 , ylzz17 , ylzz18 , xh , cjjg , cjjgmc , fdjh , clsbdh , csys , clpp , tzsh , tzbj , tzrq , clbj , qzclbj , jbr , ydclbj , spdz , sbbh,HPHM || '#' || HPZL || '#' || substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) || '#' || WFXW || '#' || WFDD esid,HPHM || '#' || HPZL || '#' || substr(to_char(wfsj,'yyyy-mm-dd hh24:mi:ss'),0,19) || '#' || WFXW || '#' || WFDD id   from  (select a.* from(select * from ZCKJ.VM_VIO_SURVEIL  where GXSJ is not null and  GXSJ<![CDATA[ >= ]]>to_date(#{start}, 'YYYY-MM-DD HH24:MI:SS') and GXSJ<![CDATA[ < ]]>to_date(#{end}, 'YYYY-MM-DD HH24:MI:SS')) a left outer join (select xh from ZCKJ.VM_VIO_SURVEIL_DEL where GXSJ<![CDATA[ >= ]]>sysdate-30)b  on a.XH=b.XH where b.XH is null) tab",
            "</script>"
    })
    List<Vio> getIncreSurveilVm(@Param("start") String start, @Param("end") String end);

    @DBSource(name = "bokang")
    List<Vio> getIncreSurveilByTable(@Param("start") String start,@Param("end") String end,@Param("table") String table);

    @DBSource(name = "bokang")
    List<Vio> getIncreVioByTable(@Param("start") String start,@Param("end") String end,@Param("table") String table);

    @DBSource(name = "bokang")
    List<Vio> vioSureilDelHisRange(@Param("start") String start,@Param("end") String end,@Param("table") String table);

    @DBSource(name = "bokang")
    List<Vio> getIncreSurveilByTableAndHphm(@Param("start") String start,@Param("end") String end,@Param("table") String table,@Param("hphm") String hphm);

    @DBSource(name = "bokang")
    List<Vio> getIncreVioByTableAndHphm(@Param("start") String start,@Param("end") String end,@Param("table") String table,@Param("hphm") String hphm);
}
