package com.hikcreate.update_hbase.dao;

import com.hikcreate.update_hbase.annotation.DBSource;
import com.hikcreate.update_hbase.entity.*;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

@Component
public interface DmsmpMapper {

    @DBSource(name = "bokang")
    List<VehTempPlate> getTempPlateWarn(@Param("times") int times);
    @DBSource(name = "hik")
    void insertTempPlateWarn(VehTempPlate vehTempPlate);

    @DBSource(name = "bokang")
    List<PlateAndSyrChange> getPlateAndSyrChange(List<String> xhList);

    @DBSource(name = "bokang")
    String getGlbmMcByCode(@Param("glbm") String glbm);

    @DBSource(name = "bokang")
    String getDmsmByDmz(@Param("dmz") String dmz,@Param("xtlb")  String xtlb,@Param("dmlb")  String dmlb);

    @DBSource(name = "hik")
    void insertPlateAndSyrChange(PlateAndSyrChange plateAndSyrChange);

    @DBSource(name = "bokang")
    String getLastSyr(@Param("xh") String xh,@Param("lsh") String lsh);

    @DBSource(name = "bokang")
    List<String> getYNXh(@Param("day") int day);

    @DBSource(name = "hik")
    List<String> getMysqlYNXh();

    @DBSource(name = "bokang")
    List<VehModify> getVehModifyXhYN(@Param("xh") String xh);

    @DBSource(name = "bokang")
    List<CommonSyr> getHisCommonSyr();

    @DBSource(name = "bokang")
    List<CommonSyr> getIncrCommonSyr(@Param("day") int day);

    @DBSource(name = "hik")
    void insertCommonSyr(CommonSyr commonSyr);

    @DBSource(name = "bokang")
    List<DrvSfzmhmXmChange> getHisDrvNameCardChange(List<String> dabhList);

    @DBSource(name = "bokang")
    List<String> getHisDrvNameCardChangeDabh();

    @DBSource(name = "hik")
    void insertDrvSfzmhmXmChange(DrvSfzmhmXmChange drvSfzmhmXmChange);

    @DBSource(name = "hik")
    List<CerticateQuit> getAllCerticateQuit();

    @DBSource(name = "hik")
    void saveCerticateQuit(CerticateQuit certicateQuit);

    @DBSource(name = "bokang")
    List<String> getPlateAndSyrChangeXh();

    @DBSource(name = "bokang")
    List<CerticateQuit> getIncrCerticateQuit(int day);

    @DBSource(name = "bokang")
    List<SyrPlateChangeMany> hisSyrPlateChangeMany();

    @DBSource(name = "hik")
    void insertSyrPlateChangeMany(SyrPlateChangeMany syrPlateChangeMany);

    @DBSource(name = "hik")
    void delSyrPlateChangeManyBySyr(String id_);

    @DBSource(name = "hik")
    List<SyrPlateChangeMany> getAllSyrPlateChangeMany();

    @DBSource(name = "bokang")
    List<MortgageCancel> getHisMortgageCancel();

    @DBSource(name = "hik")
    void insertMortgageCancel(MortgageCancel mortgageCancel);

    @DBSource(name = "bokang")
    VehLog getNextVehLog4h(@Param("xh") String xh,@Param("ywlx") String ywlx,@Param("ywyy") String ywyy,
                         @Param("bjrq") Date bjrq,@Param("jbr") String jbr);

    @DBSource(name = "bokang")
    Integer getCountNextVehLog4h(@Param("xh") String xh,@Param("ywlx") String ywlx,@Param("ywyy") String ywyy,
                                 @Param("bjrq") Date bjrq,@Param("jbr") String jbr);

    @DBSource(name = "hik")
    void insertRetireDealAgain(RetireDealAgain retireDealAgain);

    @DBSource(name = "hik")
    void insertDeformedproposer(Deformedproposer deformedproposer);
}
