package com.hikcreate.update_hbase.dao;

import com.hikcreate.update_hbase.annotation.DBSource;
import com.hikcreate.update_hbase.entity.Driver;
import com.hikcreate.update_hbase.entity.DrvFlow;
import com.hikcreate.update_hbase.entity.Vehicle;
import com.hikcreate.update_hbase.entity.Vio;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public interface OracleDao {
    /**
     * 机动车
     *
     * @param days 几天前的当天
     * @return 当天的离线增量和实时表增量去重后结果
     */
    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select a.* from (select * from ZCKJ.VM_VEHICLE_GY where GXRQ is not null and   GXRQ <![CDATA[ >= ]]>to_date(to_char(sysdate-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') AND GXRQ <![CDATA[ < ]]> to_date(to_char(sysdate,'yyyy-mm-dd'), 'yyyy-mm-dd') ) a left outer join (select * from ZCKJ.VEHICLE_GY where GXRQ is not null and   GXRQ <![CDATA[ >= ]]>to_date(to_char(sysdate-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') AND GXRQ <![CDATA[ < ]]> to_date(to_char(sysdate,'yyyy-mm-dd'), 'yyyy-mm-dd')) b on a.hphm=b.hphm and a.hpzl=b.hpzl where( a.gxrq<![CDATA[ >= ]]>b.gxrq or b.hphm is null) and a.HPHM is not null ",
            "</script>"
    })
    List<Vehicle> getDaysAgoVehicle(@Param("DAYS") int days);

    @DBSource(name="bokang")
    @Select("select a.*,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0206' and DMZ=a.JZQX and ROWNUM=1) jzqx_value,regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(ZT,'A','正常 '),'B','超分 '),'C','转出 '),'D','暂扣 '),'E','撤销 '),'F','吊销 '),'G','注销 '),'H','违法未处理 '),'I','事故未处理 '),'J','停止使用 '),'K','扣押 '),'L','锁定 '),'M','逾期未换证 '),'N','延期换证 '),'P','延期体检 '),'R','注销可恢复 '),'S','逾期未审验 '),'T','延期审验 '),'U','扣留 ') zt_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0002' and DMZ=a.LY  and ROWNUM=1) ly_value,(select sc.jxmc from ZCKJ.VM_JG_EXAM_SCHOOLINFO sc where sc.JXDM=a.JXMC  and ROWNUM=1) jxmc_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.XZQH  and ROWNUM=1) xzqh_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0051' and DMZ=a.XZQJ  and ROWNUM=1) xzqj_value,(select BMMC from ZCKJ.VM_FRM_DEPARTMENT_CODE depart where depart.GLBM=a.GLBM  and ROWNUM=1) glbm_value,regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(xgzl,'A','身份证明 '),'B','机动车驾驶证申请表 '),'C','身体条件证明 '),'D','原驾驶证 '),'E','复员转业退伍证明 '),'F','驾驶证中文翻译文本 '),'G','居住、暂住证明 '),'H','准考证明 '),'I','科目一考试成绩表 '),'J','科目二考试成绩表 '),'K','科目三考试成绩表 '),'L','驾校培训证明 '),'N','驾证注销证明 '),'P','裁决文件 '),'Q','代理人身份证明 '),'R','身份证号码变更证明 '),'S','接受教育凭证 '),'T','机动车驾驶人身体情况申报表 '),'U','从业单位出具的证明 '),'V','县级公安机关出具的无犯罪、吸毒行为记录证明原件 '),'W','内地居民往来港澳通行证 '),'X','大陆居民往来台湾通行证 '),'Y','军车驾驶员基本信息登记表 '),'Z','其它材料 ') xgzl_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='2019' and DMZ=a.SFZMMC  and ROWNUM=1) sfzmmc_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0211' and DMZ=a.HMCD  and ROWNUM=1) hmcd_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0035' and DMZ=a.XB  and ROWNUM=1) xb_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0031' and DMZ=a.GJ  and ROWNUM=1) gj_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.djzsxzqh  and ROWNUM=1) djzsxzqh_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.lxzsxzqh  and ROWNUM=1) lxzsxzqh_value \n" +
            "from ZCKJ.VM_DRIVINGLICENSE_GY a where sfzmhm=#{idcard}")
    Driver getDriverByIdcard(String idcard);





    /**
     * 违法violation
     *
     * @param days 几天前的当天
     * @return 当天的离线增量和实时表增量去重后结果
     */
    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select a.wfbh,a.jdslb,a.jdsbh,a.wsjyw,a.ryfl,a.jszh,a.dabh,a.fzjg,a.zjcx,a.dsr,a.zsxzqh,a.zsxxdz,a.dh,a.lxfs,a.clfl,a.hpzl,a.hphm,a.jdcsyr,a.syxz,a.jtfs,substr(to_char(a.wfsj,'yyyy-mm-ddhh24:mi:ss'),0,19)wfsj,a.xzqh,a.dllx,a.glxzdj,a.wfdd,a.lddm,a.ddms,a.ddjdwz,a.wfdz,a.wfxw,a.wfjfs,a.fkje,a.scz,a.bzz,a.znj,a.zqmj,a.jkfs,a.fxjg,a.fxjgmc,a.cljg,a.cljgmc,a.cfzl,a.clsj,a.jkbj,a.jkrq,a.pzbh,a.jsjqbj,a.jllx,a.lrr,a.lrsj,a.jbr1,a.jbr2,a.sgdj,a.cldxbj,a.jdccldxbj,a.zdjlbj,a.xxly,a.xrms,a.dkbj,a.jmznjbj,a.zdbj,a.jsjg,a.fsjg,a.gxsj,a.bz,a.ywjyw,a.zjmc,a.cclzrq,a.nl,a.xb,a.hcbj,a.jd,a.wd,a.ylzz1,a.ylzz2,a.ylzz3,a.ylzz4,a.ylzz5,a.ylzz6,a.ylzz7,a.ylzz8,a.cjfs,a.wfsj1,a.wfdd1,a.lddm1,a.ddms1,a.jsrxz,a.clyt,a.xcfw,a.dzzb,a.sfzdry,a.xysfzmhm,a.xyxm,a.ylzz11,a.ylzz12,a.ylzz13,a.ylzz14,a.ylzz15,a.ylzz16,a.ylzz17,a.ylzz18,null,null,null,null,null,null,null,null,null,'1',null,null,null,null,null,null from (select * from ZCKJ.VM_VIO_VIOLATION where GXSJ is not null and   GXSJ <![CDATA[ >= ]]>to_date(to_char(sysdate-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') AND GXSJ <![CDATA[ < ]]> to_date(to_char(sysdate+1-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') ) a left outer join (select * from ZCKJ.VIO_VIOLATION where GXSJ is not null and   GXSJ <![CDATA[ >= ]]>to_date(to_char(sysdate-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') AND GXSJ <![CDATA[ < ]]> to_date(to_char(sysdate+1-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd')) b on a.wfbh=b.wfbh where( a.GXSJ<![CDATA[ > ]]>b.GXSJ or b.wfbh is null) and a.HPHM is not null ",
            "</script>"
    })
    List<Vio> getDaysAgoVio(@Param("DAYS") int days);

    /**
     * 违法surveil
     *
     * @param days 几天前的当天
     * @return 当天的离线增量和实时表增量去重后结果
     */
    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select a.wfbh,a.jdslb,a.jdsbh,a.wsjyw,null,null,null,a.fzjg,null,a.dsr,a.zsxzqh,a.zsxxdz,a.dh,a.lxfs,a.clfl,a.hpzl,a.hphm,a.jdcsyr,a.syxz,a.jtfs,substr(to_char(a.wfsj,'yyyy-mm-ddhh24:mi:ss'),0,19)wfsj,a.xzqh,a.dllx,a.glxzdj,a.wfdd,a.lddm,a.ddms,a.ddjdwz,a.wfdz,a.wfxw,null,a.fkje,a.scz,a.bzz,null,a.zqmj,a.jkfs,null,null,a.cljg,a.cljgmc,null,a.clsj,a.jkbj,a.jkrq,a.pzbh,null,a.jllx,a.lrr,a.lrsj,null,null,null,a.cldxbj,null,a.zdjlbj,null,a.xrms,a.dkbj,null,a.zdbj,a.jsjg,a.fsjg,a.gxsj,a.bz,null,null,null,null,null,null,null,null,a.ylzz1,a.ylzz2,a.ylzz3,a.ylzz4,a.ylzz5,a.ylzz6,a.ylzz7,a.ylzz8,a.cjfs,null,null,null,null,null,a.clyt,a.xcfw,a.dzzb,null,null,null,a.ylzz11,a.ylzz12,a.ylzz13,a.ylzz14,a.ylzz15,a.ylzz16,a.ylzz17,a.ylzz18,a.xh,a.cjjg,a.cjjgmc,a.fdjh,a.clsbdh,a.csys,a.clpp,a.tzsh,a.tzbj,a.tzrq,a.clbj,a.qzclbj,a.jbr,a.ydclbj,a.spdz,a.sbbh from (select * from ZCKJ.VM_VIO_SURVEIL where GXSJ is not null and   GXSJ <![CDATA[ >= ]]>to_date(to_char(sysdate-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') AND GXSJ <![CDATA[ < ]]> to_date(to_char(sysdate+1-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') and clbj=0 ) a left outer join (select * from ZCKJ.VIO_SURVEIL where GXSJ is not null and   GXSJ <![CDATA[ >= ]]>to_date(to_char(sysdate-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') AND GXSJ <![CDATA[ < ]]> to_date(to_char(sysdate+1-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') and clbj=0) b on a.xh=b.xh where( a.GXSJ<![CDATA[ > ]]>b.GXSJ or b.xh is null) and a.HPHM is not null ",
            "</script>"
    })
    List<Vio> getDaysAgoSur(@Param("DAYS") int days);


    /**
     * 驾驶证
     *
     * @param days 几天前的当天
     * @return 当天的离线增量和实时表增量去重后结果
     */
    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select a1.* from (select a.*,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0206' and DMZ=a.JZQX and ROWNUM=1) jzqx_value,regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(ZT,'A','正常 '),'B','超分 '),'C','转出 '),'D','暂扣 '),'E','撤销 '),'F','吊销 '),'G','注销 '),'H','违法未处理 '),'I','事故未处理 '),'J','停止使用 '),'K','扣押 '),'L','锁定 '),'M','逾期未换证 '),'N','延期换证 '),'P','延期体检 '),'R','注销可恢复 '),'S','逾期未审验 '),'T','延期审验 '),'U','扣留 ') zt_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0002' and DMZ=a.LY  and ROWNUM=1) ly_value,(select sc.jxmc from ZCKJ.VM_JG_EXAM_SCHOOLINFO sc where sc.JXDM=a.JXMC  and ROWNUM=1) jxmc_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.XZQH  and ROWNUM=1) xzqh_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0051' and DMZ=a.XZQJ  and ROWNUM=1) xzqj_value,(select BMMC from ZCKJ.VM_FRM_DEPARTMENT_CODE depart where depart.GLBM=a.GLBM  and ROWNUM=1) glbm_value,regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(xgzl,'A','身份证明 '),'B','机动车驾驶证申请表 '),'C','身体条件证明 '),'D','原驾驶证 '),'E','复员转业退伍证明 '),'F','驾驶证中文翻译文本 '),'G','居住、暂住证明 '),'H','准考证明 '),'I','科目一考试成绩表 '),'J','科目二考试成绩表 '),'K','科目三考试成绩表 '),'L','驾校培训证明 '),'N','驾证注销证明 '),'P','裁决文件 '),'Q','代理人身份证明 '),'R','身份证号码变更证明 '),'S','接受教育凭证 '),'T','机动车驾驶人身体情况申报表 '),'U','从业单位出具的证明 '),'V','县级公安机关出具的无犯罪、吸毒行为记录证明原件 '),'W','内地居民往来港澳通行证 '),'X','大陆居民往来台湾通行证 '),'Y','军车驾驶员基本信息登记表 '),'Z','其它材料 ') xgzl_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='2019' and DMZ=a.SFZMMC  and ROWNUM=1) sfzmmc_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0211' and DMZ=a.HMCD  and ROWNUM=1) hmcd_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0035' and DMZ=a.XB  and ROWNUM=1) xb_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0031' and DMZ=a.GJ  and ROWNUM=1) gj_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.djzsxzqh  and ROWNUM=1) djzsxzqh_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.lxzsxzqh  and ROWNUM=1) lxzsxzqh_value from ZCKJ.VM_DRIVINGLICENSE_GY a where GXSJ is not null and   GXSJ <![CDATA[ >= ]]>to_date(to_char(sysdate-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') AND GXSJ <![CDATA[ < ]]> to_date(to_char(sysdate,'yyyy-mm-dd'), 'yyyy-mm-dd') ) a1 left outer join (select * from ZCKJ.DRIVINGLICENSE_GY where GXSJ is not null and   GXSJ <![CDATA[ >= ]]>to_date(to_char(sysdate-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') AND GXSJ<![CDATA[ < ]]>to_date(to_char(sysdate,'yyyy-mm-dd'), 'yyyy-mm-dd')) b on a1.SFZMHM=b.SFZMHM  where( a1.GXSJ<![CDATA[ >= ]]>b.GXSJ or b.SFZMHM is null) and a1.SFZMHM is not null",
            "</script>"
    })
    List<Driver> getDaysAgoDrv(@Param("DAYS") int days);

    /**
     * 驾驶证
     *
     * @param startDate,endDate 某个时间范围的数据
     * @return 当天的离线增量和实时表增量去重后结果
     */
    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select a.*,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0206' and DMZ=a.JZQX and ROWNUM=1) jzqx_value,regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(ZT,'A','正常 '),'B','超分 '),'C','转出 '),'D','暂扣 '),'E','撤销 '),'F','吊销 '),'G','注销 '),'H','违法未处理 '),'I','事故未处理 '),'J','停止使用 '),'K','扣押 '),'L','锁定 '),'M','逾期未换证 '),'N','延期换证 '),'P','延期体检 '),'R','注销可恢复 '),'S','逾期未审验 '),'T','延期审验 '),'U','扣留 ') zt_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0002' and DMZ=a.LY  and ROWNUM=1) ly_value,(select sc.jxmc from ZCKJ.VM_JG_EXAM_SCHOOLINFO sc where sc.JXDM=a.JXMC  and ROWNUM=1) jxmc_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.XZQH  and ROWNUM=1) xzqh_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0051' and DMZ=a.XZQJ  and ROWNUM=1) xzqj_value,(select BMMC from ZCKJ.VM_FRM_DEPARTMENT_CODE depart where depart.GLBM=a.GLBM  and ROWNUM=1) glbm_value,regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(regexp_replace(xgzl,'A','身份证明 '),'B','机动车驾驶证申请表 '),'C','身体条件证明 '),'D','原驾驶证 '),'E','复员转业退伍证明 '),'F','驾驶证中文翻译文本 '),'G','居住、暂住证明 '),'H','准考证明 '),'I','科目一考试成绩表 '),'J','科目二考试成绩表 '),'K','科目三考试成绩表 '),'L','驾校培训证明 '),'N','驾证注销证明 '),'P','裁决文件 '),'Q','代理人身份证明 '),'R','身份证号码变更证明 '),'S','接受教育凭证 '),'T','机动车驾驶人身体情况申报表 '),'U','从业单位出具的证明 '),'V','县级公安机关出具的无犯罪、吸毒行为记录证明原件 '),'W','内地居民往来港澳通行证 '),'X','大陆居民往来台湾通行证 '),'Y','军车驾驶员基本信息登记表 '),'Z','其它材料 ') xgzl_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='2019' and DMZ=a.SFZMMC  and ROWNUM=1) sfzmmc_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='02' and DMLB='0211' and DMZ=a.HMCD  and ROWNUM=1) hmcd_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0035' and DMZ=a.XB  and ROWNUM=1) xb_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='00' and DMLB='0031' and DMZ=a.GJ  and ROWNUM=1) gj_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.djzsxzqh  and ROWNUM=1) djzsxzqh_value,(select DMSM1 from ZCKJ.FRM_CODE where XTLB='90' and DMLB='9005' and DMZ=a.lxzsxzqh  and ROWNUM=1) lxzsxzqh_value from zckj.VM_DRIVINGLICENSE_GY a where GXSJ is not null and to_char(GXSJ,'YYYY-MM-DD')<![CDATA[ >= ]]>#{startDate}  and to_char(GXSJ,'YYYY-MM-DD')<![CDATA[ <= ]]>#{endDate}",
            "</script>"
    })
    List<Driver>insertDriverHbaseByRang(@Param("startDate") String startDate,@Param("endDate")String endDate);
    /**
     * 驾驶证业务流水表
     *
     * @param updateTime 上次更新时间
     * @return 二十分钟前的增量数据
     */
    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select a.lsh as id,a.* from zckj.DRV_FLOW a where a.GXSJ is not null and a.GXSJ<![CDATA[ > ]]>to_date(#{GXTIME}, 'YYYY-MM-DD HH24:MI:SS') order by a.GXSJ desc ",
            "</script>"
    })
    List<DrvFlow> getIncrementDrvFlow(@Param("GXTIME") String updateTime);


    /**
     * 驾驶证业务流水表
     *
     * @param days 几天前的当天
     * @return 当天的离线增量和实时增量去重后的结果
     */
    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select a.lsh as id, a.* from (select * from zckj.VM_DRV_FLOW where GXSJ is not null and GXSJ <![CDATA[ >= ]]>to_date(to_char(sysdate-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') AND GXSJ <![CDATA[ < ]]> to_date(to_char(sysdate+1-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') ) a left outer join (select * from ZCKJ.DRV_FLOW where GXSJ is not null and   GXSJ <![CDATA[ >= ]]>to_date(to_char(sysdate-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd') AND GXSJ <![CDATA[ < ]]> to_date(to_char(sysdate+1-#{DAYS},'yyyy-mm-dd'), 'yyyy-mm-dd')) b on a.SFZMHM=b.SFZMHM  where( a.GXSJ<![CDATA[ > ]]>b.GXSJ or b.SFZMHM is null) and a.SFZMHM is not null ",
            "</script>"
    })
    List<DrvFlow> getDaysAgeoDrvFlow(@Param("DAYS") int days);

    /**
     * 驾驶证业务流水表
     *
     * @return 全表数据
     */
    @DBSource(name = "bokang")
    @Select({
            "<script>",
            "select lsh as id,* from zckj.VM_DRV_FLOW ",
            "</script>"
    })
    List<DrvFlow> getAllDrvFlow();

}
