/*
package com.hikcreate.update_hbase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonObject;
import com.hikcreate.update_hbase.dao.DmsmpMapper;
import com.hikcreate.update_hbase.dao.DrvFlowMapper;
import com.hikcreate.update_hbase.dao.VehFlowMapper;
import com.hikcreate.update_hbase.dao.VehicleMapper;
import com.hikcreate.update_hbase.entity.*;
import com.hikcreate.update_hbase.service.DmsmpService;
import com.hikcreate.update_hbase.utils.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("dmsmpServiceImpl")
public class DmsmpServiceImpl implements DmsmpService {

    @Autowired
    private DmsmpMapper dmsmpMapper;
    @Autowired
    private VehFlowMapper vehFlowMapper;
    @Autowired
    private VehicleMapper vehicleMapper;
    @Autowired
    private DrvFlowMapper drvFlowMapper;
    @Autowired
    private KafkaTemplate kafkaTemplate;
    @Value("${app.kafka.dmsmp.topic}")
    private String dmsmpTopic;

    */
/**
     * 临时号牌预警
     *
     * @param times
     *//*

    @Override
    public void tempplateWarn(int times) {
        //查询昨天正好办理第四次的车辆的信息
        List<VehTempPlate> tempPlateList = dmsmpMapper.getTempPlateWarn(times);
        //插入数据
        if (tempPlateList.size() > 0) {
            for (VehTempPlate vehTempPlate : tempPlateList) {
                if (!vehTempPlate.getGlbm().startsWith("5201")) {
                    continue;
                }
                dmsmpMapper.insertTempPlateWarn(vehTempPlate);
                JSONObject json = new JSONObject();
                json.put("WARN_TYPE", "warn_temp_plate");
                kafkaTemplate.send(dmsmpTopic, UUID.randomUUID().toString(), json.toJSONString());
            }
        }
    }

    */
/**
     * 所有人和车牌都改变
     *//*

    @Override
    public void plateAndSyrChange(int day) {
        List<String> xhList = dmsmpMapper.getPlateAndSyrChangeXh();
        List<PlateAndSyrChange> plateAndSyrChangeList = dmsmpMapper.getPlateAndSyrChange(xhList);
        List<PlateAndSyrChange> resultList = new ArrayList<>();
        for (PlateAndSyrChange plateAndSyrChange : plateAndSyrChangeList) {
            if (day != 0) {
                if (plateAndSyrChange.getBgrq().before(DateUtil.getPastDate(new Date(), day))) {
                    continue;
                }
            }
            //补充其他字段
            VehFlow vehFlow = vehFlowMapper.getByLsh(plateAndSyrChange.getLsh());
            if (vehFlow != null) {
                if (!vehFlow.getGlbm().startsWith("5201")) {
                    continue;
                }
                String glbm_value = dmsmpMapper.getGlbmMcByCode(vehFlow.getGlbm());
                plateAndSyrChange.setGlbm(vehFlow.getGlbm());
                plateAndSyrChange.setGlbm_value(glbm_value);
            }
            Vehicle vehicle = vehicleMapper.getVehByXh(plateAndSyrChange.getXh());
            VehOut vehOut = vehicleMapper.getClshdhByXhFromVehOut(plateAndSyrChange.getXh());
            if (vehicle == null && vehOut == null) {
                continue;
            }
            if (vehicle == null && vehOut.getClsbdh() == null) {
                continue;
            }
            if (vehicle != null) {
                //判断当前所有人是否是个人
                if (vehicle.getSyq() != null && !"2".equals(vehicle.getSyq())) {
                    continue;
                }
                plateAndSyrChange.setClsbdh(vehicle.getClsbdh());
                plateAndSyrChange.setClxh(vehicle.getClxh());
                plateAndSyrChange.setCllx(vehicle.getCllx());
                plateAndSyrChange.setSyxz(vehicle.getSyxz());
                plateAndSyrChange.setCcdjrq(vehicle.getCcdjrq());
                plateAndSyrChange.setCllx_value(dmsmpMapper.getDmsmByDmz(vehicle.getCllx(), "00", "1004"));
                plateAndSyrChange.setSyxz_value(dmsmpMapper.getDmsmByDmz(vehicle.getSyxz(), "00", "1003"));
                plateAndSyrChange.setSfzmmc_value(dmsmpMapper.getDmsmByDmz(plateAndSyrChange.getSfzmmc(), "00", "2019"));
            } else if (vehOut.getClsbdh() != null) {
                plateAndSyrChange.setClsbdh(vehOut.getClsbdh());
            }
            plateAndSyrChange.setSyr(dmsmpMapper.getLastSyr(plateAndSyrChange.getXh(), plateAndSyrChange.getLsh()));
            plateAndSyrChange.setInsert_date(DateUtil.getDate());
            resultList.add(plateAndSyrChange);
        }
        for (PlateAndSyrChange plateAndSyrChange : resultList) {
            JSONObject json = new JSONObject();
            json.put("WARN_TYPE", "warn_plate_and_syr_change");
            kafkaTemplate.send(dmsmpTopic, UUID.randomUUID().toString(), json.toJSONString());
            dmsmpMapper.insertPlateAndSyrChange(plateAndSyrChange);
        }
        System.out.println("plateAndSyrChange  over ---------------------");
    }

    */
/**
     * 共同所有人
     *
     * @param day
     *//*

    @Override
    public void commonSyr(int day) {
        List<CommonSyr> commonSyrList = new ArrayList<>();
        List<CommonSyr> resList = new ArrayList<>();
        //同步历史的
        commonSyrList = dmsmpMapper.getHisCommonSyr();
        for (CommonSyr commonSyr : commonSyrList) {
            if (day != 0) {
                if (commonSyr.getBgrq().before(DateUtil.getPastDate(new Date(), day))) {
                    continue;
                }
            }
            commonSyr.setInsert_date(DateUtil.getDate());
            VehFlow vehFlow = vehFlowMapper.getByLsh(commonSyr.getLsh());
            if (vehFlow != null) {
                if (!vehFlow.getGlbm().startsWith("5201")) {
                    continue;
                }
                String glbm_value = dmsmpMapper.getGlbmMcByCode(vehFlow.getGlbm());
                commonSyr.setGlbm(vehFlow.getGlbm());
                commonSyr.setGlbm_value(glbm_value);
            } else {
                continue;
            }
            Vehicle vehicle = vehicleMapper.getVehByXh(commonSyr.getXh());
            VehOut vehOut = vehicleMapper.getClshdhByXhFromVehOut(commonSyr.getXh());
            if (vehicle == null && vehOut == null) {
                continue;
            }
            if (vehicle == null && vehOut.getClsbdh() == null) {
                continue;
            }
            if (vehicle != null) {
                if (vehicle.getSyq() != null && !"2".equals(vehicle.getSyq())) {
                    continue;
                }
                commonSyr.setClsbdh(vehicle.getClsbdh());
                commonSyr.setClxh(vehicle.getClxh());
                commonSyr.setCllx(vehicle.getCllx());
                commonSyr.setSyxz(vehicle.getSyxz());
                commonSyr.setCcdjrq(DateUtil.parseDate(vehicle.getCcdjrq()));
                commonSyr.setCllx_value(dmsmpMapper.getDmsmByDmz(vehicle.getCllx(), "00", "1004"));
                commonSyr.setSyxz_value(dmsmpMapper.getDmsmByDmz(vehicle.getSyxz(), "00", "1003"));
            } else if (vehOut.getClsbdh() != null) {
                commonSyr.setClsbdh(vehOut.getClsbdh());
            }
            resList.add(commonSyr);
        }
        for (CommonSyr commonSyr : resList) {
            JSONObject json = new JSONObject();
            json.put("WARN_TYPE", "warn_common_syr");
            kafkaTemplate.send(dmsmpTopic, UUID.randomUUID().toString(), json.toJSONString());
            dmsmpMapper.insertCommonSyr(commonSyr);
        }
        System.out.println("commonSyr  over ---------------------");
    }

    */
/**
     * 姓名和身份证号同时变更
     *
     * @param day
     *//*

    @Override
    public void drvNameAndCard(int day) {
        List<String> dabhList = dmsmpMapper.getHisDrvNameCardChangeDabh();
        List<DrvSfzmhmXmChange> drvSfzmhmXmChangeList = dmsmpMapper.getHisDrvNameCardChange(dabhList);
        List<DrvSfzmhmXmChange> resultList = new ArrayList<>();
        for (DrvSfzmhmXmChange drvSfzmhmXmChange : drvSfzmhmXmChangeList) {
            if (day != 0 && drvSfzmhmXmChange.getBgrq().before(DateUtil.getPastDate(new Date(), day))) {
                continue;
            }
            String xm = drvSfzmhmXmChange.getXm();
            drvSfzmhmXmChange.setXm(xm.substring(1, xm.length() - 1));
            String sfzmhm = drvSfzmhmXmChange.getSfzmhm();
            drvSfzmhmXmChange.setSfzmhm(sfzmhm.substring(1, sfzmhm.length() - 1));
            drvSfzmhmXmChange.setInsert_date(DateUtil.getDate());
            DrvFlow drvFlow = drvFlowMapper.getByLsh(drvSfzmhmXmChange.getLsh());
            if (drvFlow != null) {
                if (!drvFlow.getGlbm().startsWith("5201")) {
                    continue;
                }
                String glbm_value = dmsmpMapper.getGlbmMcByCode(drvFlow.getGlbm());
                drvSfzmhmXmChange.setGlbm(drvFlow.getGlbm());
                drvSfzmhmXmChange.setGlbm_value(glbm_value);
            } else {
                continue;
            }
            resultList.add(drvSfzmhmXmChange);
        }
        for (DrvSfzmhmXmChange drvSfzmhmXmChange : resultList) {
            JSONObject json = new JSONObject();
            json.put("WARN_TYPE", "warn_drv_name_card");
            kafkaTemplate.send(dmsmpTopic, UUID.randomUUID().toString(), json.toJSONString());
            dmsmpMapper.insertDrvSfzmhmXmChange(drvSfzmhmXmChange);
        }
        System.out.println("drvNameAndCard  over ---------------------");
    }

    */
/**
     * 制证后退办
     *
     * @param day
     *//*

    @Override
    public void certicateQuit(int day) {
        if (day == 0) {
            List<CerticateQuit> certicateQuitList = dmsmpMapper.getAllCerticateQuit();
            for (CerticateQuit certicateQuit : certicateQuitList) {
                if (!certicateQuit.getGlbm().startsWith("5201")) {
                    continue;
                }
                String glbm_value = dmsmpMapper.getGlbmMcByCode(certicateQuit.getGlbm());
                certicateQuit.setGlbm_value(glbm_value);
                Vehicle vehicle = vehicleMapper.getVehByXh(certicateQuit.getXh());
                if (vehicle != null) {
                    if (vehicle.getSyq() != null && !"2".equals(vehicle.getSyq())) {
                        continue;
                    }
                    certicateQuit.setSfzmhm(vehicle.getSfzmhm());
                }
                dmsmpMapper.saveCerticateQuit(certicateQuit);
                JSONObject json = new JSONObject();
                json.put("WARN_TYPE", "warn_certicate_quit");
                kafkaTemplate.send(dmsmpTopic, UUID.randomUUID().toString(), json.toJSONString());
            }
        } else {
            List<CerticateQuit> certicateQuitList = dmsmpMapper.getIncrCerticateQuit(day);
            for (CerticateQuit certicateQuit : certicateQuitList) {
                String glbm_value = dmsmpMapper.getGlbmMcByCode(certicateQuit.getGlbm());
                certicateQuit.setGlbm_value(glbm_value);
                dmsmpMapper.saveCerticateQuit(certicateQuit);
                JSONObject json = new JSONObject();
                json.put("WARN_TYPE", "warn_certicate_quit");
                kafkaTemplate.send(dmsmpTopic, UUID.randomUUID().toString(), json.toJSONString());
            }
        }
        System.out.println("certicateQuit  over ---------------------");
    }

    */
/**
     * 同一所有人多次变更号牌
     *
     * @param day
     *//*

    @Override
    public void syrPlateChangeMany(int day) {
        List<SyrPlateChangeMany> syrPlateChangeManyList = dmsmpMapper.getAllSyrPlateChangeMany();
        for (SyrPlateChangeMany syrPlateChangeMany : syrPlateChangeManyList) {
            if (day > 0 && syrPlateChangeMany.getBgrq().before(DateUtil.getPastDate(new Date(), day))) {
                continue;
            }
            syrPlateChangeMany.setInsert_date(DateUtil.getDate());
            Vehicle vehicle = vehicleMapper.getVehByXh(syrPlateChangeMany.getXh());
            if (vehicle == null) {
                dmsmpMapper.delSyrPlateChangeManyBySyr(syrPlateChangeMany.getId_());
            } else {
                syrPlateChangeMany.setSfzmhm(vehicle.getSfzmhm());
                syrPlateChangeMany.setGlbm_value(dmsmpMapper.getGlbmMcByCode(syrPlateChangeMany.getGlbm()));
                dmsmpMapper.insertSyrPlateChangeMany(syrPlateChangeMany);
                JSONObject json = new JSONObject();
                json.put("WARN_TYPE", "warn_syr_plate_change_many");
                kafkaTemplate.send(dmsmpTopic, UUID.randomUUID().toString(), json.toJSONString());
            }
        }
        System.out.println("syrPlateChangeMany  over ---------------------");
    }

    */
/**
     * 车辆短期解押
     *
     * @param day
     *//*

    @Override
    public void getHisMortgageCancel(int day) {
        List<MortgageCancel> mortgageCancelList = dmsmpMapper.getHisMortgageCancel();
        if (mortgageCancelList.size() > 0) {
            for (MortgageCancel mortgageCancel : mortgageCancelList) {
                if (day > 0 && mortgageCancel.getBlsj().before(DateUtil.getPastDate(new Date(), day))) {
                    continue;
                }
                if (!mortgageCancel.getGlbm().startsWith("5201")) {
                    continue;
                }
                mortgageCancel.setInsert_date(DateUtil.getDate());
                mortgageCancel.setGlbm_value(dmsmpMapper.getGlbmMcByCode(mortgageCancel.getGlbm()));
                Vehicle vehicle = vehicleMapper.getVehByXh(mortgageCancel.getXh());
                if (vehicle == null) {
                    continue;
                }
                mortgageCancel.setSfzmhm(vehicle.getSfzmhm());
                VehLog vehLog = vehicleMapper.getVehLogByLshFrist(mortgageCancel.getId_());
                mortgageCancel.setJbr(vehLog.getJbr());
                dmsmpMapper.insertMortgageCancel(mortgageCancel);
                JSONObject json = new JSONObject();
                json.put("WARN_TYPE", "warn_veh_mortgage_cancel");
                kafkaTemplate.send(dmsmpTopic, UUID.randomUUID().toString(), json.toJSONString());
            }
        }
        System.out.println("车辆短期解押  over ---------------------");
    }

    */
/**
     * 退办业务短期办结
     *
     * @param day
     *//*

    @Override
    public void getHisRetireDealAgain(int day) {
        Map<String, String> ztMap = new HashMap<>();
        ztMap.put("1", "正常");
        ztMap.put("2", "嫌疑");
        ztMap.put("E", "完成");
        ztMap.put("Q", "退办");
        List<VehFlow> vehFlowList = vehFlowMapper.getRetireFlow();
        for (VehFlow vehFlow : vehFlowList) {
            if (day > 0 && vehFlow.getBjrq().before(DateUtil.getPastDate(new Date(), day))) {
                continue;
            }
            //查询经办人
            VehLog vehLog = vehicleMapper.getVehLogByLshFrist(vehFlow.getLsh());
            VehLog vehLogNext = dmsmpMapper.getNextVehLog4h(vehFlow.getXh(), vehFlow.getYwlx(), vehFlow.getYwyy(),
                    vehFlow.getBjrq(), vehLog.getJbr());
            if (vehLogNext != null) {
                VehFlow nextVehFlow = vehFlowMapper.getByLsh(vehLogNext.getLsh());
                if ("Q".equals(nextVehFlow.getLszt())) {
                    continue;
                }
                RetireDealAgain retireDealAgain = new RetireDealAgain();
                retireDealAgain.setGlbm(nextVehFlow.getGlbm());
                retireDealAgain.setId_(nextVehFlow.getLsh());
                retireDealAgain.setInsert_date(DateUtil.getDate());
                retireDealAgain.setGlbm_value(dmsmpMapper.getGlbmMcByCode(nextVehFlow.getGlbm()));
                retireDealAgain.setSqlx(dmsmpMapper.getDmsmByDmz(vehLogNext.getYwlx(), "01", "0060"));
                retireDealAgain.setClxh(nextVehFlow.getClxh());
                Vehicle vehicle = vehicleMapper.getVehByXh(nextVehFlow.getXh());
                if (vehicle == null) {
                    continue;
                }
                retireDealAgain.setSfzmhm(vehicle.getSfzmhm());
                retireDealAgain.setSyr(vehFlow.getSyr());
                Integer num = dmsmpMapper.getCountNextVehLog4h(vehFlow.getXh(), vehFlow.getYwlx(), vehFlow.getYwyy(),
                        vehFlow.getBjrq(), vehLog.getJbr());
                retireDealAgain.setCs(num);
                retireDealAgain.setBlsj(vehLogNext.getClrq());
                retireDealAgain.setJbr(vehLogNext.getJbr());
                retireDealAgain.setBjzt(ztMap.get(nextVehFlow.getLszt()));
                retireDealAgain.setScblsj(vehFlow.getBjrq());
                retireDealAgain.setScjbr(vehLog.getJbr());
                retireDealAgain.setScbjzt(ztMap.get(vehFlow.getLszt()));
                retireDealAgain.setXh(vehFlow.getXh());
                retireDealAgain.setLsh(vehLogNext.getLsh());
                dmsmpMapper.insertRetireDealAgain(retireDealAgain);
                JSONObject json = new JSONObject();
                json.put("WARN_TYPE", "warn_retire_deal_again");
                kafkaTemplate.send(dmsmpTopic, UUID.randomUUID().toString(), json.toJSONString());
            }
        }
        System.out.println("退办业务短期办结  over ---------------------");
    }


    */
/**
     * 同步残疾人车辆代码：：规则---审批通过，符合条件，核发通过
     * @param day
     *//*

    @Override
    public void synDeformedproposer(int day) {
        List<Deformedproposer> deformedproposerList=null;
        if (day==0){
            deformedproposerList=vehicleMapper.getHisDeformedCar();
        }else {
            deformedproposerList=vehicleMapper.getDeformedCar(day);
        }
        for(Deformedproposer deformedproposer:deformedproposerList){
            dmsmpMapper.insertDeformedproposer(deformedproposer);
        }
        System.out.println("同步残疾人车辆完成。。。。。。。。。。。。");
    }

}
*/
