package com.hikcreate.update_hbase.service.impl;

import com.hikcreate.update_hbase.dao.BokanMapper;
import com.hikcreate.update_hbase.dao.DriverHBMapper;
import com.hikcreate.update_hbase.dao.OracleDao;
import com.hikcreate.update_hbase.entity.*;
import com.hikcreate.update_hbase.service.DriverService;
import com.hikcreate.update_hbase.utils.EsUtils;
import com.hikcreate.update_hbase.utils.HbaseEntityUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.*;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.Date;
import java.util.List;

/**
 * @author yulong shu
 * @version 1.0
 * @date 2021/5/12 16:37
 */
@Service("DriverServiceImpl")
public class DriverServiceImpl implements DriverService {
    private static Configuration hbaseConf;
    @Value("${hbase.zookeeper.property.clientPort}")
    private String hbaseAddress;
    @Value("${hbase.zookeeper.quorum}")
    private String hbaseZkQuorum;
    private static org.apache.hadoop.hbase.client.Connection hbaseConn;
    @Value("${hbase.driver.table}")
    private String driverTableStr;
    @Value("${hbase.driver_index.table}")
    private String driverIndexTableStr;
    private static TableName driverTableName;
    private static Table driverTable;
    private static TableName driverIndexTableName;
    private static Table driverIndexTable;
    @Autowired
    private OracleDao oracleDao;
    @Autowired
    private DriverHBMapper driverMapper;
    @Autowired
    private BokanMapper bokmp;
    private EsUtils esUtils;

    private void openHbaseCon() {
        hbaseConf = HBaseConfiguration.create();
        hbaseConf.set("hbase.zookeeper.property.clientPort", hbaseAddress);
        hbaseConf.set("hbase.zookeeper.quorum", hbaseZkQuorum);
    }
/*
*根据月份补数据
* 2021-09-05
* kaiwang
* */
    @Override
    public  void insertDriver2HbaseByMonth(String month){
        String rowkey;
        Put put;
        openHbaseCon();
        Table driverTable = null;
        Table driverIndexTable = null;
        try {
            hbaseConn = ConnectionFactory.createConnection(hbaseConf);
            driverTable = hbaseConn.getTable(TableName.valueOf(driverTableStr));
            driverIndexTable = hbaseConn.getTable(TableName.valueOf(driverIndexTableStr));
            List<Driver> driverList = bokmp.insertDriver2HbaseByMonth(month);
            if (driverList.size() > 0) {
                for (Driver driver : driverList) {
                    driver.setXm(driver.getXm().trim());
                    driver.setSfzmhm(driver.getSfzmhm().trim());
                    rowkey = (driver.getSfzmhm() == null ? "null" : driver.getSfzmhm());
                    Get get = new Get(rowkey.getBytes());
                    get.addColumn(Bytes.toBytes("info"), Bytes.toBytes("gxsj"));
                    get.setCheckExistenceOnly(true);
                    Result result = driverTable.get(get);
                    if (result.size() > 0) {
                        for (Cell cell : result.rawCells()) {
                            String colName = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                            String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                            if ("gxsj".equals(colName) && value.length() > 18 && driver.getGxsj().length() > 18
                                    && !(driver.getGxsj().substring(0, 19).compareTo(value.substring(0, 19)) > 0)) {
                                return;
                            }
                        }
                    }
                    put = new Put(rowkey.getBytes());
                    put = HbaseEntityUtil.getHbaseEntityPut(driver, put);
                    driverTable.put(put);
                    Put put1 = new Put((driver.getDabh() == null ? "null" : driver.getDabh()).getBytes());
                    put1.addColumn("key_fam".getBytes(), "keyone".getBytes(), rowkey.getBytes());
                    driverIndexTable.put(put1);
                    System.out.println(month+":driver数据更新完毕!");
                    //String json = getJsonString(driver, rowkey, driver.getDabh() == null ? "null" : driver.getDabh());
                    //kafkaTemplate.send(diverTopic, json);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            closeHbase();
        }
    }
    @Override
    public void insertDriver2Hbase(String idcard) {
        String rowkey;
        //flag=0:不插入，flag=1：插入hbase并发kafka并写索引表，
        int flag;
        Put put;
        openHbaseCon();
        try {
            hbaseConn = ConnectionFactory.createConnection(hbaseConf);
            driverTable = hbaseConn.getTable(TableName.valueOf(driverTableStr));
            driverIndexTable = hbaseConn.getTable(TableName.valueOf(driverIndexTableStr));
            Driver driver = oracleDao.getDriverByIdcard(idcard);
            int count = 0;
            driver.setSfzmhm(driver.getSfzmhm().trim());
            driver.setXm(driver.getXm().trim());
            flag = 1;
            rowkey = (driver.getSfzmhm() == null ? "null" : driver.getSfzmhm());
            Get get = new Get(rowkey.getBytes());
            get.addColumn(Bytes.toBytes("info"), Bytes.toBytes("gxsj"));
            Result result = driverTable.get(get);
            if (result.size() > 0) {//已存在hbase中，比较gxsj
                for (Cell cell : result.rawCells()) {
                    String colName = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                    String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                    if ("gxsj".equals(colName) && value.length() >= 19 && driver.getGxsj().length() >= 19
                            && driver.getGxsj().substring(0, 19).compareTo(value.substring(0, 19)) < 0) {
                        flag = 0;
                    } else {
                        flag = 1;
                    }
                }
            } else {
                flag = 1;
            }
            if (flag == 1) {
                put = new Put(rowkey.getBytes());
                put = HbaseEntityUtil.getHbaseEntityPut(driver, put);
                driverTable.put(put);
//                        logger.info("drv-1--rowkey:" + rowkey);
                Put put1 = new Put((driver.getDabh() == null ? "null" : driver.getDabh()).getBytes());
                put1.addColumn("key_fam".getBytes(), "keyone".getBytes(), rowkey.getBytes());
                driverIndexTable.put(put1);
            }

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            closeHbase();
        }
    }
    private  void closeHbase() {
        if (hbaseConn != null) {
            try {
                hbaseConn.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        closeHbaseTable(driverTable);
        closeHbaseTable(driverIndexTable);
    }
    private void closeHbaseTable(Table table) {
        if (table != null) {
            try {
                table.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     *同步driver一段时间范围的数据到hbase
     * kaiwang
     * 2021-09-07
     * */
    @Override
    public  void  insertDriverHbaseByRang(String startDate,String endDate){
        String rowkey;
        Put put;
        openHbaseCon();
        Table driverTable = null;
        Table driverIndexTable = null;
        try {
            hbaseConn = ConnectionFactory.createConnection(hbaseConf);
            driverTable = hbaseConn.getTable(TableName.valueOf(driverTableStr));
            driverIndexTable = hbaseConn.getTable(TableName.valueOf(driverIndexTableStr));
            List<Driver> driverList = oracleDao.insertDriverHbaseByRang(startDate,endDate);
            if (driverList.size() > 0) {
                for (Driver driver : driverList) {
                    driver.setXm(driver.getXm().trim());
                    driver.setSfzmhm(driver.getSfzmhm().trim());
                    rowkey = (driver.getSfzmhm() == null ? "null" : driver.getSfzmhm());
                    Get get = new Get(rowkey.getBytes());
                    get.addColumn(Bytes.toBytes("info"), Bytes.toBytes("gxsj"));
                    get.setCheckExistenceOnly(true);
                    Result result = driverTable.get(get);
                    if (result.size() > 0) {
                        for (Cell cell : result.rawCells()) {
                            String colName = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                            String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                            if ("gxsj".equals(colName) && value.length() > 18 && driver.getGxsj().length() > 18
                                    && !(driver.getGxsj().substring(0, 19).compareTo(value.substring(0, 19)) > 0)) {
                                return;
                            }
                        }
                    }
                    put = new Put(rowkey.getBytes());
                    put = HbaseEntityUtil.getHbaseEntityPut(driver, put);
                    driverTable.put(put);
                    Put put1 = new Put((driver.getDabh() == null ? "null" : driver.getDabh()).getBytes());
                    put1.addColumn("key_fam".getBytes(), "keyone".getBytes(), rowkey.getBytes());
                    driverIndexTable.put(put1);
                    System.out.println(startDate+"-"+endDate+":driver数据更新完毕!");
                    //String json = getJsonString(driver, rowkey, driver.getDabh() == null ? "null" : driver.getDabh());
                    //kafkaTemplate.send(diverTopic, json);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            closeHbase();
        }

    }
}
