/*
package com.hikcreate.update_hbase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hikcreate.update_hbase.Repo.DrvFlowRepository;
import com.hikcreate.update_hbase.dao.OracleDao;
import com.hikcreate.update_hbase.entity.*;
import com.hikcreate.update_hbase.redis.RedisUtil;
import com.hikcreate.update_hbase.service.EveryDayScheduleService;
import com.hikcreate.update_hbase.utils.DateUtil;
import com.hikcreate.update_hbase.utils.EsUtils;
import com.hikcreate.update_hbase.utils.HbaseEntityUtil;
import com.hikcreate.update_hbase.utils.HbaseUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.*;
import org.apache.hadoop.hbase.util.Bytes;
import org.elasticsearch.client.transport.TransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Service("everyDayScheduleServiceImpl")
public class EveryDayScheduleServiceImpl implements EveryDayScheduleService {
    @Autowired
    private KafkaTemplate kafkaTemplate;
    private static Logger logger = LoggerFactory.getLogger(UpdateHbaseServiceImpl.class);
    @Autowired
    private OracleDao oracleDao;
    @Autowired
    private TransportClient transportClient;
    @Autowired
    private EsUtils esUtils;

    @Autowired
    private RedisUtil redisUtil;
    @Value("${hbase.zookeeper.property.clientPort}")
    private String hbaseAddress;
    @Value("${hbase.zookeeper.quorum}")
    private String hbaseZkQuorum;
    @Value("${hbase.master}")
    private String hbaseMaster;
    private static Configuration hbaseConf;
    private static org.apache.hadoop.hbase.client.Connection hbaseConn;
    @Value("${hbase.vehicle.table}")
    private String vehicleTableStr;
    private static TableName vehicleTableName;
    private static Table vehicleTable;
    @Value("${hbase.vehicle_index.table}")
    private String vehicleIndexTableStr;
    private static TableName vehicleIndexTableName;
    private static Table vehicleIndexTable;
    @Value("${hbase.driver.table}")
    private String driverTableStr;
    @Value("${hbase.driver_index.table}")
    private String driverIndexTableStr;
    private static TableName driverTableName;
    private static Table driverTable;
    private static TableName driverIndexTableName;
    private static Table driverIndexTable;
    @Value("${hbase.drv_flow.table}")
    private String drFlowTableStr;
    @Value("${hbase.drv_flow_index.table}")
    private String drvFlowIndexTableStr;
    private static TableName drFlowTableName;
    private static Table drFlowTable;
    private static TableName drvFlowIndexTableName;
    private static Table drvFlowIndexTable;

    @Value("${hbase.vio.table}")
    private String vioTableStr;
    @Value("${hbase.vio_index.table}")
    private String vioIndexTableStr;


*/
/*    @Value("${es.drvflow.index}")
    private String drvFlowIndex;
    @Value("${es.drvflow.type}")
    private String drvFlowType;*//*

    @Value("${app.kafka.driver.topic}")
    private String diverTopic;
    @Value("${app.kafka.vio.topic}")
    private String vioTopic;
    @Value("${app.kafka.vehicle.topic}")
    private String vehicleTopic;
    @Value("${app.kafka.drv_flow.topic}")
    private String drvFlowTopic;
    @Autowired
    private HbaseUtil hbaseUtil;
    @Autowired
    private DrvFlowRepository drvFlowRepository;


    */
/**
     * 违法
     *
     * @param days 抽取几天前的当天数据？days=1 就是昨天的数据
     *//*

    @Override
    public void getViolationData(int days) {
        openHbaseCon();
        try {
            Connection hbaseConn = ConnectionFactory.createConnection(hbaseConf);
            Table vioTable = hbaseConn.getTable(TableName.valueOf(vioTableStr));
            Table vioIndexTable = hbaseConn.getTable(TableName.valueOf(vioIndexTableStr));
            List<Vio> surveilList = oracleDao.getDaysAgoSur(days);
            List<Vio> violationList = oracleDao.getDaysAgoVio(days);
            int count = 0;
            int num = 0;
            if (surveilList.size() > 0) {//非现场违法结果
                for (Vio vio : surveilList) {
                    count = count + insertVio2Hbase(vio, vioTable, vioIndexTable);
                    num = num + 1;
                }
                logger.info("surveil导入数据：" + count + "/" + num);
            }
            if (violationList.size() > 0) {//违法主表结果
                for (Vio vio : violationList) {
                    count = count + insertVio2Hbase(vio, vioTable, vioIndexTable);
                    num = num + 1;
                }
            }
            logger.info("vio和surveil总计插入数据:" + count + "/" + num);
            logger.info("违法数据增量更新成功");
            vioIndexTable.close();
            hbaseConn.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private int insertVio2Hbase(Vio vio, Table messTable, Table indexTable) throws IOException {
        //flag=0:不插入，flag=1：插入hbase并发kafka并写索引表
        int flag = 1;
        String rowkey = (vio.getHphm() == null ? "null" : vio.getHphm()) + "#" +
                (vio.getHpzl() == null ? "null" : vio.getHpzl()) + "#" +
                (vio.getWfsj() == null ? "null" : vio.getWfsj()) + "#" +
                (vio.getWfxw() == null ? "null" : vio.getWfxw());
        Get get = new Get(rowkey.getBytes());
        get.addColumn(Bytes.toBytes("useful"), Bytes.toBytes("gxsj"));
        Result result = messTable.get(get);
        if (result.size() > 0) {
            for (Cell cell : result.rawCells()) {
                String colName = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                if ("gxsj".equals(colName) && value.length() >= 19 && vio.getGxsj().length() >= 19
                        && vio.getGxsj().substring(0, 19).compareTo(value.substring(0, 19)) < 0) {
                    flag = 0;
                } else {
                    flag = 1;
                }
            }
        } else {
            flag = 1;
        }
        if (flag == 1) {
            Put put = new Put(rowkey.getBytes());
            put = HbaseEntityUtil.getHbaseEntityPut(vio, put);
            messTable.put(put);
            String rowkey1 = (vio.getJszh() == null ? "null" : vio.getJszh()) + "#" +
                    (vio.getWfsj() == null ? "null" : vio.getWfsj()) + "#" + (vio.getWfxw() == null ? "null" : vio.getWfxw());
            Put put1 = new Put(rowkey1.getBytes());
            put1.addColumn("key_fam".getBytes(), "key".getBytes(), rowkey.getBytes());
            indexTable.put(put1);
            //发kafka
            String json = getJsonString(vio, rowkey, (vio.getJszh() == null ? "null" : vio.getJszh()) + "#" +
                    (vio.getWfsj() == null ? "null" : vio.getWfsj()) + "#" + (vio.getWfxw() == null ? "null" : vio.getWfxw()));
            kafkaTemplate.send(vioTopic, json);
            return 1;
        } else {
            return 0;
        }
    }

    */
/**
     * 机动车
     *
     * @param days 抽取几天前的当天数据？days=1 就是昨天的数据
     *//*

    @Override
    public void getVehicleData(int days) {
        String rowkey;
        String indexRowkey;
        String indexCloum;
        Put put;
        openHbaseCon();
        try {
            hbaseConn = ConnectionFactory.createConnection(hbaseConf);
            vehicleTable = hbaseConn.getTable(TableName.valueOf(vehicleTableStr));
            vehicleIndexTable = hbaseConn.getTable(TableName.valueOf(vehicleIndexTableStr));
            List<Vehicle> vehicleList = oracleDao.getDaysAgoVehicle(days);
            if (vehicleList.size() > 0) {
                int count = 0;
                int num = 0;
                for (Vehicle vehicle : vehicleList) {
                    num = num + 1;
                    rowkey = (vehicle.getHphm() == null ? "null" : vehicle.getHphm()) + "#" + (vehicle.getHpzl() == null ? "null" : vehicle.getHpzl());
                    indexRowkey = (vehicle.getSfzmhm() == null ? "null" : vehicle.getSfzmhm());
                    indexCloum = (vehicle.getCcdjrq() == null ? "null" : vehicle.getCcdjrq().substring(0, 10));
                    count = count + 1;
                    //机动车基本信息put
                    put = new Put(rowkey.getBytes());
                    put = HbaseEntityUtil.getHbaseEntityPut(vehicle, put);
                    vehicleTable.put(put);
                    //机动车索引信息put
                    Put indexPut = new Put(indexRowkey.getBytes());
                    indexPut.addColumn("key_fam".getBytes(), indexCloum.getBytes(), rowkey.getBytes());
                    vehicleIndexTable.put(indexPut);
                    //发kafka
                    String json = getJsonString(vehicle, rowkey, vehicle.getSfzmhm() == null ? "null" : vehicle.getSfzmhm());
                    kafkaTemplate.send(vehicleTopic, json);
                }
                logger.info("veh插入数据:" + count + "/" + num);
                logger.info("机动车增量数据更新成功");
            } else {
                logger.info(new Date() + "==>" + "veh新数据为0");
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            closeHbase();
        }

    }


    */
/**
     * 驾驶证
     *
     * @param days 抽取几天前的当天数据？days=1 就是昨天的数据
     *//*

    @Override
    public void getDrivinglicenseData(int days) {
        String rowkey;
        //flag=0:不插入，flag=1：插入hbase并发kafka并写索引表，
        int flag;
        Put put;
        openHbaseCon();
        try {
            hbaseConn = ConnectionFactory.createConnection(hbaseConf);
            driverTable = hbaseConn.getTable(TableName.valueOf(driverTableStr));
            driverIndexTable = hbaseConn.getTable(TableName.valueOf(driverIndexTableStr));
            List<Driver> driverList = oracleDao.getDaysAgoDrv(days);
            if (driverList.size() > 0) {
                int count = 0;
                int num = 0;
                for (Driver driver : driverList) {
                    driver.setSfzmhm(driver.getSfzmhm().trim());
                    driver.setXm(driver.getXm().trim());
                    num = num + 1;
                    flag = 1;
                    rowkey = (driver.getSfzmhm() == null ? "null" : driver.getSfzmhm());
                    Get get = new Get(rowkey.getBytes());
                    get.addColumn(Bytes.toBytes("info"), Bytes.toBytes("gxsj"));
                    Result result = driverTable.get(get);
                    if (result.size() > 0) {//已存在hbase中，比较gxsj
                        for (Cell cell : result.rawCells()) {
                            String colName = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                            String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                            if ("gxsj".equals(colName) && value.length() >= 19 && driver.getGxsj().length() >= 19
                                    && driver.getGxsj().substring(0, 19).compareTo(value.substring(0, 19)) < 0) {
                                flag = 0;
                            } else {
                                flag = 1;
                            }
                        }
                    } else {
                        flag = 1;
                    }
                    if (flag == 1) {
                        count = count + 1;
                        put = new Put(rowkey.getBytes());
                        put = HbaseEntityUtil.getHbaseEntityPut(driver, put);
                        driverTable.put(put);
//                        logger.info("drv-1--rowkey:" + rowkey);
                        Put put1 = new Put((driver.getDabh() == null ? "null" : driver.getDabh()).getBytes());
                        put1.addColumn("key_fam".getBytes(), "keyone".getBytes(), rowkey.getBytes());
                        driverIndexTable.put(put1);
                        //发kafka
                        String json = getJsonString(driver, rowkey, driver.getDabh() == null ? "null" : driver.getDabh());
                        kafkaTemplate.send(diverTopic, json);
                    }
                }
                logger.info("drv插入数据:" + count + "/" + num);
                logger.info("驾驶人增量数据更新成功");
            } else {
                logger.info(new Date() + "==>" + "drv新数据为0");
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            closeHbase();
        }
    }

    */
/**
     * 按天导入drvFlow数据
     *
     * @param days 天
     *//*

    @Override
    public void getDrvFlowDayData(int days) {
        String rowkey;
        String indexRowkey;
        //flag=0:不插入，flag=1：插入hbase并发kafka并写索引表，
        int flag;
        Put put;
        openHbaseCon();
        try {
            hbaseConn = ConnectionFactory.createConnection(hbaseConf);
            drFlowTable = hbaseConn.getTable(TableName.valueOf(drFlowTableStr));
            drvFlowIndexTable = hbaseConn.getTable(TableName.valueOf(drvFlowIndexTableStr));
            //String updateTime = EsUtils.getGxsj(redisClient, day, "updateHbase_DrvFlow_updateTime");
            List<DrvFlow> drvFlowList = oracleDao.getDaysAgeoDrvFlow(days);
            if (drvFlowList.size() > 0) {
                int count = 0;
                int num = 0;
                processDrvflow(drvFlowList, count, num);
            }
            drvFlowIndexTable.close();
            drFlowTable.close();
            hbaseConn.close();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }

    }

    */
/**
     * @param drvFlowList 查询结果列表
     * @param count       插入总数
     * @param num         查询总数
     * @throws IOException
     * @throws IllegalAccessException
     *//*

    private void processDrvflow(List<DrvFlow> drvFlowList, int count, int num) throws IOException, IllegalAccessException {
        int flag;
        String rowkey;
        String indexRowkey;
        for (DrvFlow drvFlow : drvFlowList) {
            DrvFlow oldDrvFlow = new DrvFlow();
            num = num + 1;
            flag = 1;
            rowkey = (drvFlow.getLsh() == null ? "null" : drvFlow.getLsh());
            indexRowkey = (drvFlow.getSfzmhm() == null ? "null" : drvFlow.getSfzmhm());
            Get get = new Get(rowkey.getBytes());
            get.addColumn(Bytes.toBytes("info"), Bytes.toBytes("gxsj"));
            Result result = drFlowTable.get(get);
            if (result.size() > 0) {//已存在hbase中，比较gxsj
                for (Cell cell : result.rawCells()) {
                    String colName = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                    String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                    Field[] fields = oldDrvFlow.getClass().getFields();
                    for (Field field : fields) {
                        if (field.equals(colName)) {
                            field.set(oldDrvFlow, value);
                        }
                    }
                    if ("gxsj".equals(colName) && value.length() >= 19 && drvFlow.getGxsj().length() >= 19//Oracle查询出来的数据更新时间小于hbase
                            && drvFlow.getGxsj().substring(0, 19).compareTo(value.substring(0, 19)) < 0) {
                        flag = 0;
                    } else {//Oracle查询出来的数据更新时间大于hbase
                        flag = 1;
                    }
                }
            } else {//不存在hbase中
                flag = 1;
            }
            if (flag == 1) {//数据是更新或新入
                count = count + 1;
                //写hbase
                hbaseUtil.addDrvFlowAndIndex(drFlowTable, drvFlowIndexTable, drvFlow);
                //写es
                drvFlow2Es(drvFlow);
                //发kafka
                String json = getJsonString(rowkey, indexRowkey, drvFlow, oldDrvFlow);
                kafkaTemplate.send(drvFlowTopic, json);
            }
        }
    }

    */
/**
     * 每二十分钟查询导入drvflow数据
     * @param day 天
     *//*

    @Override
    public void getDrvFlowMinuData(String day) {
        //flag=0:不插入，flag=1：插入hbase并发kafka并写索引表，
        openHbaseCon();
        try {
            hbaseConn = ConnectionFactory.createConnection(hbaseConf);
            drFlowTable = hbaseConn.getTable(TableName.valueOf(drFlowTableStr));
            drvFlowIndexTable = hbaseConn.getTable(TableName.valueOf(drvFlowIndexTableStr));
            String updateTime = esUtils.getGxsj(redisUtil, day, "updateHbase_DrvFlow_updateTime");
            List<DrvFlow> drvFlowList = oracleDao.getIncrementDrvFlow(updateTime);
            if (drvFlowList.size() > 0) {
                int count = 0;
                int num = 0;
                processDrvflow(drvFlowList, count, num);
                //更新redis里面的最新更新时间
                redisUtil.set("updateHbase_DrvFlow_updateTime", drvFlowList.get(0).getGxsj());
            }
            drvFlowIndexTable.close();
            drFlowTable.close();
            hbaseConn.close();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }


    */
/**
     * drvflow对象插入es
     *
     * @param drvFlow
     *//*

    private void drvFlow2Es(DrvFlow drvFlow) {
        Optional<DrvFlow> drvFlowById = drvFlowRepository.findById(drvFlow.getId());
        if (drvFlowById.isPresent()) {
            DrvFlow drvFlow1 = drvFlowById.get();
            if (!(drvFlow1.getGxsj().substring(0, 19).compareTo(drvFlow.getGxsj().substring(0, 19)) < 0)) {
                return;
            }
        }
        drvFlowRepository.save(drvFlow);
    }

    */
/**
     * 把drvflow索引hbase表全量插入
     *//*

    @Override
    public void getDrvFlowIndexAll() {
        List<DrvFlow> drvFlowList = oracleDao.getAllDrvFlow();
        if (drvFlowList.size() > 0) {
            try {
                hbaseUtil.addDrvFlowIndex(drvFlowIndexTableStr, drvFlowList);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getJsonString(Object obj, String rowkey, String row_index) {
        JSONObject json = (JSONObject) JSONObject.toJSON(obj);
        JSONObject vehJSON = new JSONObject();
        for (Map.Entry<String, Object> entry : json.entrySet()) {
            String key = entry.getKey();
            vehJSON.put(key.substring(key.indexOf(":") + 1), entry.getValue());
        }
        KafkaJson vehicleJson = new KafkaJson();
        vehicleJson.setRow(rowkey);
        vehicleJson.setRow_index(row_index);
        JSONObject resultJson = (JSONObject) JSONObject.toJSON(vehicleJson);
        resultJson.put("data", vehJSON);
        return resultJson.toString();
    }

    private String getJsonString(String rowkey, String row_index, Object newData, Object oldData) {
        JSONObject newDataJson = (JSONObject) JSONObject.toJSON(newData);
        JSONObject oldDataJson = (JSONObject) JSONObject.toJSON(oldData);
        JSONObject newJSON = new JSONObject();
        JSONObject oldJSON = new JSONObject();
        //把前缀去掉
        for (Map.Entry<String, Object> entry : newDataJson.entrySet()) {
            String key = entry.getKey();
            newJSON.put(key.substring(key.indexOf(":") + 1), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : oldDataJson.entrySet()) {
            String key = entry.getKey();
            oldJSON.put(key.substring(key.indexOf(":") + 1), entry.getValue());
        }
        KafkaJsonConNewAndOld kafkaJsonConNewAndOld = new KafkaJsonConNewAndOld();
        kafkaJsonConNewAndOld.setRow(rowkey);
        kafkaJsonConNewAndOld.setRow_index(row_index);
        kafkaJsonConNewAndOld.setNew_data(newJSON);
        kafkaJsonConNewAndOld.setOld_data(oldJSON);
        JSONObject resultJson = (JSONObject) JSONObject.toJSON(kafkaJsonConNewAndOld);
        return resultJson.toString();
    }

    private void openHbaseCon() {
        hbaseConf = HBaseConfiguration.create();
        hbaseConf.set("hbase.zookeeper.property.clientPort", hbaseAddress);
        hbaseConf.set("hbase.zookeeper.quorum", hbaseZkQuorum);
    }

    private synchronized void closeHbase() {
        if (hbaseConn != null) {
            try {
                hbaseConn.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        closeHbaseTable(driverTable);
        closeHbaseTable(driverIndexTable);
        closeHbaseTable(vehicleTable);
        closeHbaseTable(vehicleIndexTable);
    }

    private void closeHbaseTable(Table table) {
        if (table != null) {
            try {
                table.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getGxsj(RedisUtil redisClient, String day, String keyName) {
        String updateTime;
        if (day == null) {
            updateTime = DateUtil.getDate() + " 09:30:00";
            if (redisClient.hasKey(keyName)) {
                updateTime = redisClient.get(keyName);
            }
        } else {
            updateTime = day;
        }
        return updateTime;
    }


}
*/
