package com.hikcreate.update_hbase.service.impl;

import com.hikcreate.update_hbase.Repo.SurveilRepository;
import com.hikcreate.update_hbase.dao.SurveilMapper;
import com.hikcreate.update_hbase.entity.Surveil;
import com.hikcreate.update_hbase.entity.Violation;
import com.hikcreate.update_hbase.service.SurveilService;
import com.hikcreate.update_hbase.utils.DateUtil;
import com.hikcreate.update_hbase.utils.EsUtils;
import com.hikcreate.update_hbase.utils.HbaseEntityUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.*;

@Component
public class SurveilServiceImpl implements SurveilService {

    @Autowired
    private SurveilMapper surveilMapper;
    @Autowired
    private SurveilRepository surveilRepository;
    @Value("${hbase.es.surveil}")
    private String hbaseTableStr;
    @Autowired
    private EsUtils esUtils;
    @Value("${hbase.zookeeper.property.clientPort}")
    private String hbaseAddress;
    @Value("${hbase.zookeeper.quorum}")
    private String hbaseZkQuorum;


    @Override
    public void imDataOracle2EsById(String... ids) {
        System.out.println(Arrays.toString(ids));
        List<Surveil> list = surveilMapper.getSurveilById(Arrays.asList(ids));
        System.out.println("list size:"+list.size());
        for (Surveil surveil : list) {
            surveilRepository.save(surveil);
        }
    }

    /**
     * 指定同步莫一天的数据
     * @param day
     */
    @Override
    public  void  insertDataOrc2EsBatch(String day){
        try {
            List<Surveil> list = surveilMapper.insertSurveilBatch(day);
            System.out.println("list size:" + list.size());
            surveilRepository.saveAll(list);
        }
        catch(Exception e){
            e.printStackTrace();
        }

    }
    @Override
    public void surveilDay(int len) {
        for (int i = 0; i < len; i++) {
            int finalI = i;
            new Thread(() -> {
                try {
                    List<Surveil> vmList = surveilMapper.getVmSurveil(DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI)), DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI + 1)));
                    List<Surveil> list = surveilMapper.getSurveil(DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI)), DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI + 1)));
                    List<Surveil> vmHisList = surveilMapper.getVmSurveilHis(DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI)), DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI + 1)));
                    List<Surveil> vmDelList = surveilMapper.getVmSurveilDel(DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI)), DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI + 1)));
                    List<Surveil> finalList = new ArrayList<>();
                    finalList.addAll(vmList);
                    finalList.addAll(list);
                    finalList.addAll(vmHisList);
                    finalList.addAll(vmDelList);
                    org.apache.hadoop.hbase.client.Connection hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
                    Table violationTable = hbaseConn.getTable(TableName.valueOf(hbaseTableStr));
                    for (Surveil surveil : finalList) {
                        Optional<Surveil> byId = surveilRepository.findById(surveil.getXh());
                        if (byId.isPresent() && byId.get().getGxsj().compareTo(surveil.getGxsj()) >= 0) {
                            continue;
                        }else {
                            surveilRepository.save(surveil);
                            Put put=new Put(surveil.getXh().getBytes());
                            put= HbaseEntityUtil.getHbaseEntityPutNoPrefix(surveil,put);
                            violationTable.put(put);
                        }
                    }
                    esUtils.closeHbaseTable(violationTable);
                    esUtils.closeHbaseCon(hbaseConn);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        }
    }

    /**
     * 同步小数据量表到Es的非现场违法表：vio_surveil,vm_vio_surveil_del
     * @return
     */
    @Override
    public void sysSurSmallData() {
        //vio_surveil
        for (int i = 1; i < 16; i++) {
            int finalI = i;
            new Thread(() -> {
                try {
                    List<Surveil> list = surveilMapper.getSurveil(DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI)), DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI + 1)));
                    org.apache.hadoop.hbase.client.Connection hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
                    Table violationTable = hbaseConn.getTable(TableName.valueOf(hbaseTableStr));
                    for (Surveil surveil : list) {
                        Optional<Surveil> byId = surveilRepository.findById(surveil.getXh());
                        if (byId.isPresent() && byId.get().getGxsj().compareTo(surveil.getGxsj()) >= 0) {
                            continue;
                        } else {
                            surveilRepository.save(surveil);
                            Put put = new Put(surveil.getXh().getBytes());
                            put = HbaseEntityUtil.getHbaseEntityPutNoPrefix(surveil, put);
                            violationTable.put(put);
                        }
                    }
                    esUtils.closeHbaseTable(violationTable);
                    esUtils.closeHbaseCon(hbaseConn);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        }
        //vm_vio_surveil_del
        try {
            List<Surveil> vmDelList = surveilMapper.getSurveilDelAll();
            org.apache.hadoop.hbase.client.Connection hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
            Table violationTable = hbaseConn.getTable(TableName.valueOf(hbaseTableStr));
            for (Surveil surveil : vmDelList) {
                Optional<Surveil> byId = surveilRepository.findById(surveil.getXh());
                if (byId.isPresent() && byId.get().getGxsj().compareTo(surveil.getGxsj()) >= 0) {
                    continue;
                } else {
                    surveilRepository.save(surveil);
                    Put put = new Put(surveil.getXh().getBytes());
                    put = HbaseEntityUtil.getHbaseEntityPutNoPrefix(surveil, put);
                    violationTable.put(put);
                }
            }
            esUtils.closeHbaseTable(violationTable);
            esUtils.closeHbaseCon(hbaseConn);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }



}
