/*
package com.hikcreate.update_hbase.service.impl;

import com.hikcreate.update_hbase.Repo.AcdAllRepository;
import com.hikcreate.update_hbase.Repo.AcdHumanRepository;
import com.hikcreate.update_hbase.dao.AcdMapper;
import com.hikcreate.update_hbase.entity.AcdAll;
import com.hikcreate.update_hbase.entity.AcdHuman;
import com.hikcreate.update_hbase.redis.RedisUtil;
import com.hikcreate.update_hbase.service.UpdateEsAcdService;
import com.hikcreate.update_hbase.utils.EsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service("updateEsAcdServiceImpl")
public class UpdateEsAcdServiceImpl implements UpdateEsAcdService {

    private static Logger logger = LoggerFactory.getLogger(UpdateEsAcdServiceImpl.class);

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private AcdMapper acdDao;

    @Autowired
    private AcdAllRepository acdAllRepository;
    @Autowired
    private AcdHumanRepository acdHumanRepository;
    @Autowired
    private EsUtils esUtils;

    @Value("${app.kafka.acd.topic}")
    private String acdTopic;
    @Value("${app.kafka.acd_human.topic}")
    private String acdHumanTopic;

    */
/**
     * 事故每天调度
     * @param i
     *//*

    @Override
    public void AcdEsDay(int i) {
        //查询三个事故表中前10天数据
        List<AcdAll> acdAlls = acdDao.getFileAcdPastDay(i);
        List<AcdAll> dutySimpleAcdAlls = acdDao.getDutySimpleAcdPastDay(i);
        List<AcdAll> quickAcdAlls = acdDao.getQuickAcdPastDay(i);
        acdAlls.addAll(dutySimpleAcdAlls);
        acdAlls.addAll(quickAcdAlls);
        if (acdAlls.size() > 0) {
            for (AcdAll acdAll : acdAlls) {
                insertEsAcd(acdAll);
            }
        }
    }

    private void insertEsAcd(AcdAll acdAll){
        Optional<AcdAll> byId = acdAllRepository.findById(acdAll.getId());
        if(byId.isPresent()){
            AcdAll acdAll1 = byId.get();
            if(acdAll1.getGxsj().substring(0,19).compareTo(acdAll.getGxsj().substring(0,19))<0){
                acdAllRepository.save(acdAll);
                esUtils.sendKafka(acdAll.getId(),acdAll,acdAll1,acdTopic);
            }
        }else {
            acdAllRepository.save(acdAll);
            esUtils.sendKafka(acdAll.getId(),acdAll,null,acdTopic);
        }

    }

    private void insertEsAcdHuman(AcdHuman acdHuman){
        Optional<AcdHuman> byId = acdHumanRepository.findById(acdHuman.getEsid());
        if(byId.isPresent()){
            acdHumanRepository.save(acdHuman);
        }else {
            acdHumanRepository.save(acdHuman);
            esUtils.sendKafka(acdHuman.getId(),acdHuman,null,acdHumanTopic);
        }
    }


    */
/**
     * 事故定时调度
     *//*

    @Override
    public void AcdEs20Min() {
        //获取时间
        String updateTimeFile = esUtils.getGxsj(redisUtil, null, "es_acdFile_updateTime");
        //查询增量数据
        new Thread(() -> {
            List<AcdAll> acdAlls = acdDao.getIncreAcd(updateTimeFile);
            List<AcdHuman> acdHumanList=acdDao.getIncreAcdHuman20Min(updateTimeFile);
            if (acdAlls.size() > 0) {
//                acdAlls.forEach(acdAll -> EsUtils.insertEsIdVo(acdAll, transportClient, acdIndex, acdType, kafkaTemplate, acdTopic, "esid", "gxsj"));
                acdAlls.forEach(acdAll -> {
                    insertEsAcd(acdAll);
                });
                redisUtil.set("es_acdFile_updateTime", acdAlls.get(0).getGxsj());
            }
            if(acdHumanList.size()>0){
                acdHumanList.forEach(acdHuman -> insertEsAcdHuman(acdHuman));
            }
        }).start();
    }

    */
/**
     * 事故人员每天调度
     * @param pastDay
     *//*

    @Override
    public void AcdHumanDay(int pastDay) {
        List<AcdHuman> acdHumanList= acdDao.getIncreAcdHuman(pastDay);
        List<AcdHuman> acdDutySimpleHumanList= acdDao.getIncreAcdDutySimpleHuman(pastDay);
        List<AcdHuman> acdQuickHumanList=acdDao.getIncreAcdQuickHuman(pastDay);

        new Thread(()->{
            if(acdHumanList.size()>0){
                acdHumanList.forEach(acdHuman -> insertEsAcdHuman(acdHuman));
            }
        }).start();

        new Thread(()->{
            if(acdDutySimpleHumanList.size()>0){
                acdDutySimpleHumanList.forEach(acdHuman -> insertEsAcdHuman(acdHuman));
            }
        }).start();

        new Thread(()->{
            if(acdQuickHumanList.size()>0){
                acdQuickHumanList.forEach(acdHuman -> insertEsAcdHuman(acdHuman));
            }
        }).start();
    }

}
*/
