/*
package com.hikcreate.update_hbase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hikcreate.update_hbase.Repo.VioRepository;
import com.hikcreate.update_hbase.dao.BokanMapper;
import com.hikcreate.update_hbase.dao.DriverHBMapper;
import com.hikcreate.update_hbase.entity.*;
import com.hikcreate.update_hbase.redis.RedisUtil;
import com.hikcreate.update_hbase.service.UpdateHbaseService;
import com.hikcreate.update_hbase.utils.EsUtils;
import com.hikcreate.update_hbase.utils.HbaseEntityUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.*;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.*;

@Service("updateHbaseServiceImpl")
public class UpdateHbaseServiceImpl implements UpdateHbaseService {

    @Autowired
    private KafkaTemplate kafkaTemplate;
    private static Logger logger = LoggerFactory.getLogger(UpdateHbaseServiceImpl.class);
    @Autowired
    private BokanMapper bokanDao;
    //    @Autowired
//    private TransportClient transportClient;
    @Autowired
    private VioRepository vioRepository;

    @Autowired
    private DriverHBMapper drvMaper;

    @Autowired
    private EsUtils esUtils;
    @Autowired
    private RedisUtil redisUtil;

    @Value("${hbase.zookeeper.property.clientPort}")
    private String hbaseAddress;
    @Value("${hbase.zookeeper.quorum}")
    private String hbaseZkQuorum;
    @Value("${hbase.master}")
    private String hbaseMaster;


    @Value("${hbase.vehicle.table}")
    private String vehicleTableStr;
    @Value("${hbase.vehicle_index.table}")
    private String vehicleIndexTableStr;
    @Value("${hbase.driver.table}")
    private String driverTableStr;
    @Value("${hbase.driver_index.table}")
    private String driverIndexTableStr;
    @Value("${hbase.vio.table}")
    private String vioTableStr;
    @Value("${hbase.vio_index.table}")
    private String vioIndexTableStr;


    @Value("${app.kafka.driver.topic}")
    private String diverTopic;
    @Value("${app.kafka.vio.topic}")
    private String vioTopic;
    @Value("${app.kafka.vehicle.topic}")
    private String vehicleTopic;

    @Override
    public synchronized void vehicleUpdateHbase(String day) {
        String rowkey;
        Put put;
        org.apache.hadoop.hbase.client.Connection hbaseConn = null;
        Table vehicleTable = null;
        Table vehicleIndexTable = null;
        try {
            hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
            vehicleTable = hbaseConn.getTable(TableName.valueOf(vehicleTableStr));
            vehicleIndexTable = hbaseConn.getTable(TableName.valueOf(vehicleIndexTableStr));
            String updateTime = esUtils.getGxsj(redisUtil, day, "updateHbase_Vehicle_updateTime");
            List<Vehicle> vehicleList = bokanDao.getIncrementVehicle(updateTime);
            if (vehicleList.size() > 0) {
                redisUtil.set("updateHbase_Vehicle_updateTime", vehicleList.get(0).getGxrq());
                for (Vehicle vehicle : vehicleList) {
                    rowkey = (vehicle.getHphm() == null ? "null" : vehicle.getHphm()) + "#" + (vehicle.getHpzl() == null ? "null" : vehicle.getHpzl());
                    Get get = new Get(rowkey.getBytes());
                    get.addColumn(Bytes.toBytes("info"), Bytes.toBytes("gxrq"));
                    get.setCheckExistenceOnly(true);
                    Result result = vehicleTable.get(get);
                    if (result.size() > 0) {
                        for (Cell cell : result.rawCells()) {
                            String colName = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                            String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                            if ("gxrq".equals(colName) && value.length() > 18 && vehicle.getGxrq().length() > 18
                                    && !(vehicle.getGxrq().substring(0, 19).compareTo(value.substring(0, 19)) > 0)) {
                                return;
                            }
                        }
                    }
                    put = new Put(rowkey.getBytes());
                    put = HbaseEntityUtil.getHbaseEntityPut(vehicle, put);
                    vehicleTable.put(put);
                    Put put1 = new Put((vehicle.getSfzmhm() == null ? "null" : vehicle.getSfzmhm()).getBytes());
                    put1.addColumn("key_fam".getBytes(), vehicle.getCcdjrq().substring(0, 10).getBytes(), rowkey.getBytes());
                    vehicleIndexTable.put(put1);
                    String json = getJsonString(vehicle, rowkey, vehicle.getSfzmhm() == null ? "null" : vehicle.getSfzmhm());
                    kafkaTemplate.send(vehicleTopic, json);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            esUtils.closeHbaseTable(vehicleTable);
            esUtils.closeHbaseTable(vehicleIndexTable);
            esUtils.closeHbaseCon(hbaseConn);
        }
    }


    private String getJsonString(Object obj, String rowkey, String row_index) {
        JSONObject json = (JSONObject) JSONObject.toJSON(obj);
        JSONObject vehJSON = new JSONObject();
        for (Map.Entry<String, Object> entry : json.entrySet()) {
            String key = entry.getKey();
            vehJSON.put(key.substring(key.indexOf(":") + 1), entry.getValue());
        }

        KafkaJson vehicleJson = new KafkaJson();
        vehicleJson.setRow(rowkey);
        vehicleJson.setRow_index(row_index);
        JSONObject resultJson = (JSONObject) JSONObject.toJSON(vehicleJson);
        resultJson.put("data", vehJSON);
        return resultJson.toString();
    }

    */
/**
     * 驾驶人
     *
     * @param day
     *//*

    @Override
    public synchronized void driverUpdateHbase(String day) {
        String rowkey;
        Put put;
        org.apache.hadoop.hbase.client.Connection hbaseConn = null;
        Table driverTable = null;
        Table driverIndexTable = null;
        try {
            hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
            driverTable = hbaseConn.getTable(TableName.valueOf(driverTableStr));
            driverIndexTable = hbaseConn.getTable(TableName.valueOf(driverIndexTableStr));
            String updateTime = esUtils.getGxsj(redisUtil, day, "updateHbase_Driver_updateTime");
            List<Driver> driverList = bokanDao.getIncrementDriver(updateTime);
            if (driverList.size() > 0) {
                redisUtil.set("updateHbase_Driver_updateTime", driverList.get(0).getGxsj());
                for (Driver driver : driverList) {
                    driver.setXm(driver.getXm().trim());
                    driver.setSfzmhm(driver.getSfzmhm().trim());
                    rowkey = (driver.getSfzmhm() == null ? "null" : driver.getSfzmhm());
                    Get get = new Get(rowkey.getBytes());
                    get.addColumn(Bytes.toBytes("info"), Bytes.toBytes("gxsj"));
                    get.setCheckExistenceOnly(true);
                    Result result = driverTable.get(get);
                    if (result.size() > 0) {
                        for (Cell cell : result.rawCells()) {
                            String colName = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                            String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                            if ("gxsj".equals(colName) && value.length() > 18 && driver.getGxsj().length() > 18
                                    && !(driver.getGxsj().substring(0, 19).compareTo(value.substring(0, 19)) > 0)) {
                                return;
                            }
                        }
                    }
                    put = new Put(rowkey.getBytes());
                    put = HbaseEntityUtil.getHbaseEntityPut(driver, put);
                    driverTable.put(put);
                    Put put1 = new Put((driver.getDabh() == null ? "null" : driver.getDabh()).getBytes());
                    put1.addColumn("key_fam".getBytes(), "keyone".getBytes(), rowkey.getBytes());
                    driverIndexTable.put(put1);
                    String json = getJsonString(driver, rowkey, driver.getDabh() == null ? "null" : driver.getDabh());
                    kafkaTemplate.send(diverTopic, json);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            esUtils.closeHbaseTable(driverTable);
            esUtils.closeHbaseTable(driverIndexTable);
            esUtils.closeHbaseCon(hbaseConn);
        }
    }
    */
/**
     * 驾驶人数据插入
     *
     * @param ids
     *//*

    @Override
    public  synchronized  void insertDriverById(String... ids) {
        String rowkey;
        Put put;
        org.apache.hadoop.hbase.client.Connection hbaseConn = null;
        Table driverTable = null;
        Table driverIndexTable = null;
        try {
            hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
            driverTable = hbaseConn.getTable(TableName.valueOf(driverTableStr));
            driverIndexTable = hbaseConn.getTable(TableName.valueOf(driverIndexTableStr));
            List<Driver> list = drvMaper.getDriverById(Arrays.asList(ids));
            for (Driver driver:list){
                driver.setXm(driver.getXm().trim());
                driver.setSfzmhm(driver.getSfzmhm().trim());
                rowkey = (driver.getSfzmhm() == null ? "null" : driver.getSfzmhm());
                Get get = new Get(rowkey.getBytes());
                get.addColumn(Bytes.toBytes("info"), Bytes.toBytes("sfzmhm"));
                get.setCheckExistenceOnly(true);
                Result result = driverTable.get(get);
                if (result.size() > 0) {
                    for (Cell cell : result.rawCells()) {
                        String colName = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                        String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                    }
                }
                put = new Put(rowkey.getBytes());
                put = HbaseEntityUtil.getHbaseEntityPut(driver, put);
                driverTable.put(put);
                Put put1 = new Put((driver.getDabh() == null ? "null" : driver.getDabh()).getBytes());
                put1.addColumn("key_fam".getBytes(), "keyone".getBytes(), rowkey.getBytes());
                driverIndexTable.put(put1);
            }
            //String updateTime = esUtils.getGxsj(redisUtil, ids, "updateHbase_Driver_updateTime");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            esUtils.closeHbaseTable(driverTable);
            esUtils.closeHbaseTable(driverIndexTable);
            esUtils.closeHbaseCon(hbaseConn);
        }
    }

    */
/**
     * 违法
     *
     * @param day
     *//*

    @Override
    public synchronized void vioUpdateHbase(String day) {
        try {
            org.apache.hadoop.hbase.client.Connection hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
            String updateSurveilTime = esUtils.getGxsj(redisUtil, day, "updateHbase_Surveil_updateTime");
            String updateViolationTime = esUtils.getGxsj(redisUtil, day, "updateHbase_Violation_updateTime");
            List<Vio> surveilList = bokanDao.getIncrementVioBySurveil(updateSurveilTime);
            List<Vio> violationList = bokanDao.getIncrementVioByViolation(updateViolationTime);
            new Thread(() -> {
                Table vioTable = null;
                Table vioIndexTable = null;
                try {
                    if (surveilList.size() > 0) {
                        vioTable = esUtils.getHbaseTable(hbaseConn, vioTableStr);
                        vioIndexTable = esUtils.getHbaseTable(hbaseConn, vioIndexTableStr);
                        redisUtil.set("updateHbase_Surveil_updateTime", surveilList.get(0).getGxsj());
                        for (Vio vio : surveilList) {
                            insertVio2Hbase(vio, vioTable, vioIndexTable);
                            updateEsVio(vio);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    esUtils.closeHbaseTable(vioTable);
                    esUtils.closeHbaseTable(vioIndexTable);
                }
            }).start();

            new Thread(() -> {
                Table vioTable = null;
                Table vioIndexTable = null;
                try {
                    if (violationList.size() > 0) {
                        vioTable = esUtils.getHbaseTable(hbaseConn, vioTableStr);
                        vioIndexTable = esUtils.getHbaseTable(hbaseConn, vioIndexTableStr);
                        redisUtil.set("updateHbase_Violation_updateTime", violationList.get(0).getGxsj());
                        for (Vio vio : violationList) {
                            insertVio2Hbase(vio, vioTable, vioIndexTable);
                            updateEsVio(vio);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    esUtils.closeHbaseTable(vioTable);
                    esUtils.closeHbaseTable(vioIndexTable);
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    */
/**
     * 删除hbase指定列
     *
     * @param family
     * @param tableStr
     * @param col
     *//*

    @Override
    public void delColumn(String tableStr, String family, String col) {
        try {
            org.apache.hadoop.hbase.client.Connection hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
            Table table = esUtils.getHbaseTable(hbaseConn, tableStr);
            Scan scan = new Scan();
            scan.addColumn(family.getBytes(),col.getBytes());
            ResultScanner scanner = table.getScanner(scan);
            List<Delete> deleteList=new ArrayList<>();
            scanner.forEach(result -> {
                if(result.containsColumn(family.getBytes(),col.getBytes())){
                    Delete delete = new Delete(result.getRow());
                    delete.deleteColumn(family.getBytes(),col.getBytes());
                    deleteList.add(delete);
                }
            });
            table.delete(deleteList);
            esUtils.closeHbaseTable(table);
            esUtils.closeHbaseCon(hbaseConn);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateEsVio(Vio vio) {
        Optional<Vio> byId = vioRepository.findById(vio.getId());
        if (byId.isPresent()) {
            Vio vio1 = byId.get();
            if (!(vio1.getGxsj().substring(0, 19).compareTo(vio.getGxsj().substring(0, 19)) < 0)) {
                return;
            }
            //无驾驶人的数据不能覆盖有驾驶人的数据
            if (vio1.getJszh() != null && vio.getJszh() != null && vio.getJszh().length() < 5 && vio1.getJszh().length() > 5) {
                return;
            }
        }
        vioRepository.save(vio);
    }

    private synchronized void insertVio2Hbase(Vio vio, Table vioTable, Table vioIndexTable) throws IOException {
        String rowkey = vio.getId();
        Get get = new Get(rowkey.getBytes());
        get.addColumn(Bytes.toBytes("useful"), Bytes.toBytes("gxsj"));
        get.setCheckExistenceOnly(true);
        Result result = vioTable.get(get);
        if (result.size() > 0) {
            for (Cell cell : result.rawCells()) {
                String colName = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                if ("gxsj".equals(colName) && value.length() > 18 && vio.getGxsj().length() > 18
                        && !(vio.getGxsj().substring(0, 19).compareTo(value.substring(0, 19)) > 0)) {
                    return;
                }
            }
        }
        Put put = new Put(rowkey.getBytes());
        put = HbaseEntityUtil.getHbaseEntityPut(vio, put);
        vioTable.put(put);
        String rowkey1 = vio.getJszh() + "#" + vio.getWfsj() + "#" + vio.getWfxw();
        Put put1 = new Put(rowkey1.getBytes());
        put1.addColumn("key_fam".getBytes(), "key".getBytes(), rowkey.getBytes());
        vioIndexTable.put(put1);
        String json = getJsonString(vio, rowkey, (vio.getJszh() == null ? "null" : vio.getJszh()) + "#" +
                (vio.getWfsj() == null ? "null" : vio.getWfsj()) + "#" + (vio.getWfxw() == null ? "null" : vio.getWfxw()));
        kafkaTemplate.send(vioTopic, json);
    }



    public static void main(String[] args) {
*/
/*        while (true){
            Scanner input=new Scanner(System.in);
            int n=input.nextInt();
            System.out.println(getNum(n));
        }*//*

        System.out.println(UUID.randomUUID().toString().replaceAll("-",""));
        System.out.println("2020-03-09 08:05:14.000".substring(11, 16));

    }


    public static int getNum(int n){
        if (n>3){
            return n/3+getNum(n/3+n%3);
        }else if(n==2 || n==3){
            return 1;
        }else {
            return 0;
        }
    }

}
*/
