package com.hikcreate.update_hbase.service.impl;

import com.hikcreate.update_hbase.Repo.VehFlowRepository;
import com.hikcreate.update_hbase.dao.VehFlowMapper;
import com.hikcreate.update_hbase.entity.VehFlow;
import com.hikcreate.update_hbase.service.VehFlowService;
import com.hikcreate.update_hbase.utils.EsConfig;
import org.apache.lucene.index.Terms;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Optional;

@Service("vehFlowServiceImpl")
public class VehFlowServiceImpl implements VehFlowService {
    private static Logger logger = LoggerFactory.getLogger(VehFlowServiceImpl.class);

    @Autowired
    private VehFlowMapper vehFlowMapper;
    @Autowired
    private VehFlowRepository vehFlowRepository;

    /**
     * 每天同步机动车流水表数据,现在只同步到了ES
     * @param day
     */
    @Override
    public void vehFlow2EsDay(int day) {
        List<VehFlow> vehFlowList=vehFlowMapper.getVmPast(day);
        List<VehFlow> vehFlowList1=vehFlowMapper.getTablePast(day);
        vehFlowList.addAll(vehFlowList1);
        if(vehFlowList.size()>0){
            for(VehFlow vehFlow:vehFlowList){
                Optional<VehFlow> byId = vehFlowRepository.findById(vehFlow.getLsh());
                if(byId.isPresent() && byId.get().getGxrq().compareTo(vehFlow.getGxrq())>0){
                    continue;
                }else {
                    vehFlowRepository.save(vehFlow);
                }
            }
        }
        logger.info("veh_flow完成");
    }


}
