package com.hikcreate.update_hbase.service.impl;


import com.hikcreate.update_hbase.entity.IndexHtable;
import com.hikcreate.update_hbase.service.VehicleIndexService;
import com.hikcreate.update_hbase.utils.ConnectUtil;
import com.hikcreate.update_hbase.utils.HbaseUtil;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;


@Service("VehicleIndexServiceImpl")
public class VehicleIndexServiceImpl implements VehicleIndexService {
    private static Logger logger = LoggerFactory.getLogger(VehicleIndexServiceImpl.class);
    @Autowired
    private ConnectUtil connectUtil;
    @Value("${listVehIndexall.sql}")
    private String listVehIndexall_sql;
    @Value("${listVehIndexyesterday.sql}")
    private String listVehIndexyesterday_sql;
    @Value("${listVehIndexExtra.sql}")
    private String listVehIndexExtra_sql;
    @Autowired
    private HbaseUtil hbaseUtil;

    /**
     * 机动车全量数据
     */
    @Override
    public void listVehIndexall() {
        logger.info("开始全量查询查询Oracle表：ZCKJ.VM_VEHICLE_GY");
        List<IndexHtable> indexHtables = null;
        try {
            indexHtables = selectVeh(listVehIndexall_sql);
        } catch (SQLException e) {
            e.printStackTrace();
        }
        List<Put> puts = new ArrayList<>();
        logger.info("ZCKJ.VM_VEHICLE_GY全量查询结果组建put集合");
        if (indexHtables != null && indexHtables.size() > 0) {
            for (IndexHtable indexHtable : indexHtables) {
                Put put = new Put(Bytes.toBytes(indexHtable.getRowkey()));
                put.addColumn(Bytes.toBytes("key_fam"), Bytes.toBytes(indexHtable.getCol()), Bytes.toBytes(indexHtable.getValue()));
                puts.add(put);
            }
            logger.info("put集合put到hbase表：veh:veh_index 中");
        }
        try {
            hbaseUtil.addPuts("veh:veh_index", puts);
            logger.info("put集合put到hbase表：veh:veh_index 成功");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 机动车昨日数据
     */
    @Override
    public void listVehIndexyesterday() {
        logger.info("开始查询Oracle表昨天数据：ZCKJ.VM_VEHICLE_GY");
        List<IndexHtable> indexHtables = null;
        try {
            indexHtables = selectVeh(listVehIndexyesterday_sql);
        } catch (SQLException e) {
            e.printStackTrace();
        }
        List<Put> puts = new ArrayList<>();
        logger.info("ZCKJ.VM_VEHICLE_GY昨日查询结果组建put集合");
        if (indexHtables != null && indexHtables.size() > 0) {
            for (IndexHtable indexHtable : indexHtables) {
                Put put = new Put(Bytes.toBytes(indexHtable.getRowkey()));
                put.addColumn(Bytes.toBytes("key_fam"), Bytes.toBytes(indexHtable.getCol()), Bytes.toBytes(indexHtable.getValue()));
                puts.add(put);
            }
            logger.info("put集合put到hbase表：veh:veh_index 中");
        }

        try {
            hbaseUtil.addPuts("veh:veh_index", puts);
            logger.info("put集合put到hbase表：veh:veh_index 成功");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void listVehIndexExtra() {
        logger.info("开始查询Oracle表实时表额外数据：ZCKJ.VEHICLE_GY");
        List<IndexHtable> indexHtables = null;
        try {
            indexHtables = selectVeh(listVehIndexExtra_sql);
        } catch (SQLException e) {
            e.printStackTrace();
        }

        List<Put> puts = new ArrayList<>();
        logger.info("ZCKJ.VEHICLE_GY相对于ZCKJ.VM_VEHICLE_GY额外数据组建put集合");
        if (indexHtables != null && indexHtables.size() > 0) {
            for (IndexHtable indexHtable : indexHtables) {
                Put put = new Put(Bytes.toBytes(indexHtable.getRowkey()));
                put.addColumn(Bytes.toBytes("key_fam"), Bytes.toBytes(indexHtable.getCol()), Bytes.toBytes(indexHtable.getValue()));
                puts.add(put);
            }
            logger.info("put集合put到hbase表：veh:veh_index 中");
        }

        try {
            hbaseUtil.addPuts("veh:veh_index", puts);
            logger.info("put集合put到hbase表：veh:veh_index 成功");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    /**
     * 查询Oracle的机动车基本信息表
     *
     * @param sql 查询语句
     * @return 索引字段结果
     * @throws SQLException sql异常
     */
    private List<IndexHtable> selectVeh(String sql) throws SQLException {
        Connection connection = connectUtil.getConnect();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        ResultSet resultSet = preparedStatement.executeQuery();
        List<IndexHtable> Indexlist = new ArrayList<>();
        while (resultSet.next()) {
            IndexHtable indexHtable = new IndexHtable();
            indexHtable.setCol(resultSet.getString("ccdjrq"));
            indexHtable.setRowkey(resultSet.getString("sfzmhm"));
            indexHtable.setValue(resultSet.getString("hphm") + "#" + resultSet.getString("hpzl"));
            Indexlist.add(indexHtable);
        }
        ConnectUtil.close(preparedStatement);
        ConnectUtil.close(connection);
        return Indexlist;
    }

}
