package com.hikcreate.update_hbase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hikcreate.update_hbase.Repo.VehicleEsRepository;
import com.hikcreate.update_hbase.dao.VehicleMapper;
import com.hikcreate.update_hbase.entity.KafkaJson;
import com.hikcreate.update_hbase.entity.VehEs;
import com.hikcreate.update_hbase.entity.Vehicle;
import com.hikcreate.update_hbase.entity.VehicleEs;
import com.hikcreate.update_hbase.service.VehicleService;
import com.hikcreate.update_hbase.utils.EsUtils;
import com.hikcreate.update_hbase.utils.HbaseEntityUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.*;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("vehicleServiceImpl")
public class VehicleServiceImpl implements VehicleService {

    @Autowired
    private VehicleMapper vehicleDao;
    @Autowired
    private VehicleEsRepository vehicleEsRepository;

    @Value("${hbase.vehicle.table}")
    private String vehicleTableStr;
    @Value("${hbase.vehicle_index.table}")
    private String vehicleIndexTableStr;
    @Value("${hbase.vehicle_del_check.table}")
    private String vehicleDelTableStr;
    @Value("${hbase.car.table}")
    private String carTableStr;

    @Value("${hbase.zookeeper.property.clientPort}")
    private String hbaseAddress;
    @Value("${hbase.zookeeper.quorum}")
    private String hbaseZkQuorum;
    @Autowired
    private EsUtils esUtils;
    @Autowired
    private KafkaTemplate kafkaTemplate;
    @Value("${app.kafka.vehicle.topic}")
    private String vehicleTopic;

    @Value("${app.kafka.vehDelCheck}")
    private String vehDelTopic;
    @Value("${app.kafka.car.topic}")
    private String carTopic;

    private static Logger logger = LoggerFactory.getLogger(VehicleServiceImpl.class);

    @Override
    public void getVehicle2Hbase(String hphm, String hpzl) {
        Vehicle vehicle = vehicleDao.getVehicle2Hbase(hphm, hpzl);
        org.apache.hadoop.hbase.client.Connection hbaseConn = null;
        Table vehicleTable = null;
        Table vehicleIndexTable = null;
        try {
            hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
            vehicleTable = hbaseConn.getTable(TableName.valueOf(vehicleTableStr));
            vehicleIndexTable = hbaseConn.getTable(TableName.valueOf(vehicleIndexTableStr));
            String rowkey = (vehicle.getHphm() == null ? "null" : vehicle.getHphm()) + "#" + (vehicle.getHpzl() == null ? "null" : vehicle.getHpzl());
            Put put = new Put(rowkey.getBytes());
            put = HbaseEntityUtil.getHbaseEntityPut(vehicle, put);
            vehicleTable.put(put);
            Put put1 = new Put((vehicle.getSfzmhm() == null ? "null" : vehicle.getSfzmhm()).getBytes());
            put1.addColumn("key_fam".getBytes(), vehicle.getCcdjrq().substring(0, 10).getBytes(), rowkey.getBytes());
            vehicleIndexTable.put(put1);
            String json = getJsonString(vehicle, rowkey, vehicle.getSfzmhm() == null ? "null" : vehicle.getSfzmhm());
            kafkaTemplate.send(vehicleTopic, json);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            esUtils.closeHbaseTable(vehicleTable);
            esUtils.closeHbaseTable(vehicleIndexTable);
            esUtils.closeHbaseCon(hbaseConn);
        }

    }

    @Override
    public void imDataOracle2EsById(String... ids) {
        System.out.println(Arrays.toString(ids));
        List<VehicleEs> list =vehicleDao.getVehicleById(Arrays.asList(ids));
        System.out.println("list size:"+list.size());
        for (VehicleEs vehicle : list) {
            vehicleEsRepository.save(vehicle);
        }
    }

    @Override
    public void getVehicle2HbaseAllRealTime(String day) {
        List<Vehicle> vehicles = vehicleDao.getVehicle2HbaseAllRealTime(day);
        org.apache.hadoop.hbase.client.Connection hbaseConn = null;
        Table vehicleTable = null;
        Table vehicleIndexTable = null;
        try {
            hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
            vehicleTable = hbaseConn.getTable(TableName.valueOf(vehicleTableStr));
            vehicleIndexTable = hbaseConn.getTable(TableName.valueOf(vehicleIndexTableStr));
            for (Vehicle vehicle : vehicles) {
                String rowkey = (vehicle.getHphm() == null ? "null" : vehicle.getHphm()) + "#" + (vehicle.getHpzl() == null ? "null" : vehicle.getHpzl());
                Get get=new Get(rowkey.getBytes());
                if(!get.isCheckExistenceOnly()){
                    Result result = vehicleTable.get(new Get(rowkey.getBytes()));
                    for (Cell cell : result.rawCells()){
                        String colName = Bytes.toString(cell.getQualifierArray(),cell.getQualifierOffset(),cell.getQualifierLength());
                        String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                        if(colName.equals("gxrq")){
                            if(value.compareTo(vehicle.getGxrq())>0){
                                continue;
                            }
                        }
                    }
                }
                Put put = new Put(rowkey.getBytes());
                put = HbaseEntityUtil.getHbaseEntityPut(vehicle, put);
                vehicleTable.put(put);
                Put put1 = new Put((vehicle.getSfzmhm() == null ? "null" : vehicle.getSfzmhm()).getBytes());
                put1.addColumn("key_fam".getBytes(), vehicle.getCcdjrq().substring(0, 10).getBytes(), rowkey.getBytes());
                vehicleIndexTable.put(put1);
                String json = getJsonString(vehicle, rowkey, vehicle.getSfzmhm() == null ? "null" : vehicle.getSfzmhm());
                kafkaTemplate.send(vehicleTopic, json);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            esUtils.closeHbaseTable(vehicleTable);
            esUtils.closeHbaseTable(vehicleIndexTable);
            esUtils.closeHbaseCon(hbaseConn);
        }
    }

    /**
     * 数据删除检查
     */
    @Override
    public void delVehCheck() throws Exception {
        Set<String> oracleCars = vehicleDao.getAllPlateNum();
        org.apache.hadoop.hbase.client.Connection hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
        Table vehicleTable = hbaseConn.getTable(TableName.valueOf(vehicleTableStr));
        Table vehicleDelTable = hbaseConn.getTable(TableName.valueOf(vehicleDelTableStr));
        Scan scan = new Scan();
        ResultScanner scanner = vehicleTable.getScanner(scan);
        Set<String> hbaseCars = new HashSet<>();
        scanner.forEach(res -> {
            hbaseCars.add(new String(res.getRow()));
        });
        Set<String> resSet = new HashSet<>();
        resSet.addAll(hbaseCars);
        resSet.removeAll(oracleCars);
        resSet.forEach(str -> {
            Put put = new Put(str.getBytes());
            //type=0表示hbase中有，oracle中没有----------type=1表示habse中无，oracle中有
            put.addColumn("info".getBytes(), "type".getBytes(), "1".getBytes());
            Put put1 = new Put(str.getBytes());
            put1.addColumn("info".getBytes(), "del_check_type".getBytes(), "1".getBytes());
            try {
                vehicleDelTable.put(put);
                vehicleTable.put(put1);
                JSONObject vehJSON = new JSONObject();
                vehJSON.put("rowkey", str);
                vehJSON.put("type", "1");
                kafkaTemplate.send(vehDelTopic, vehJSON.toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
        esUtils.closeHbaseTable(vehicleDelTable);
        esUtils.closeHbaseTable(vehicleTable);
        esUtils.closeHbaseCon(hbaseConn);
    }

    /**
     * 每天同步机动车数据，考虑veh_out表
     */
    @Override
    public void vehDay() throws Exception {
        List<VehicleEs> vehicleEsList = vehicleDao.getVmVeh(10);
        //实时表中有，视图中没有。或者两者都有，但实时表中数据要新的数据
        List<VehicleEs> vehicleEsList1 = vehicleDao.getVeh(10);
        vehicleEsList.addAll(vehicleEsList1);
        if (vehicleEsList.size() > 0) {
            org.apache.hadoop.hbase.client.Connection hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
            Table carTable = hbaseConn.getTable(TableName.valueOf(carTableStr));
            for (VehicleEs veh : vehicleEsList) {
                Optional<VehicleEs> byId = vehicleEsRepository.findById(veh.getXh());
                if (byId.isPresent() && byId.get().getGxrq().compareTo(veh.getGxrq()) >= 0) {
                    continue;
                }else {
                    vehicleEsRepository.save(veh);
                    Put put = new Put(veh.getXh().getBytes());
                    put = HbaseEntityUtil.getHbaseEntityPutNoPrefix(veh, put);
                    carTable.put(put);
                    JSONObject vehJSON = new JSONObject();
                    vehJSON.put("xh", veh.getXh());
                    kafkaTemplate.send(carTopic, vehJSON.toString());
                }
            }
            esUtils.closeHbaseTable(carTable);
            esUtils.closeHbaseCon(hbaseConn);
        }
        logger.info("veh_out完成");
    }

    /**
     * 更新指定时间段内的机动车视图数据
     * @param start
     * @param end
     */
    @Override
    public void getVmVehicle2Hbase(String start, String end) {
        List<Vehicle> vehicles = vehicleDao.getVmVehicle2Hbase(start,end);
        org.apache.hadoop.hbase.client.Connection hbaseConn = null;
        Table vehicleTable = null;
        Table vehicleIndexTable = null;
        try {
            hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
            vehicleTable = hbaseConn.getTable(TableName.valueOf(vehicleTableStr));
            vehicleIndexTable = hbaseConn.getTable(TableName.valueOf(vehicleIndexTableStr));
            for (Vehicle vehicle : vehicles) {
                String rowkey = (vehicle.getHphm() == null ? "null" : vehicle.getHphm()) + "#" + (vehicle.getHpzl() == null ? "null" : vehicle.getHpzl());
                Get get=new Get(rowkey.getBytes());
                if(!get.isCheckExistenceOnly()){
                    Result result = vehicleTable.get(new Get(rowkey.getBytes()));
                    for (Cell cell : result.rawCells()){
                        String colName = Bytes.toString(cell.getQualifierArray(),cell.getQualifierOffset(),cell.getQualifierLength());
                        String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                        if(colName.equals("gxrq")){
                            if(value.compareTo(vehicle.getGxrq())>0){
                                continue;
                            }
                        }
                    }
                }
                Put put = new Put(rowkey.getBytes());
                put = HbaseEntityUtil.getHbaseEntityPut(vehicle, put);
                vehicleTable.put(put);
                Put put1 = new Put((vehicle.getSfzmhm() == null ? "null" : vehicle.getSfzmhm()).getBytes());
                put1.addColumn("key_fam".getBytes(), vehicle.getCcdjrq().substring(0, 10).getBytes(), rowkey.getBytes());
                vehicleIndexTable.put(put1);
                String json = getJsonString(vehicle, rowkey, vehicle.getSfzmhm() == null ? "null" : vehicle.getSfzmhm());
                kafkaTemplate.send(vehicleTopic, json);

            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            esUtils.closeHbaseTable(vehicleTable);
            esUtils.closeHbaseTable(vehicleIndexTable);
            esUtils.closeHbaseCon(hbaseConn);
        }
    }


    private String getJsonString(Object obj, String rowkey, String row_index) {
        JSONObject json = (JSONObject) JSONObject.toJSON(obj);
        JSONObject vehJSON = new JSONObject();
        for (Map.Entry<String, Object> entry : json.entrySet()) {
            String key = entry.getKey();
            vehJSON.put(key.substring(key.indexOf(":") + 1), entry.getValue());
        }
        KafkaJson vehicleJson = new KafkaJson();
        vehicleJson.setRow(rowkey);
        vehicleJson.setRow_index(row_index);
        JSONObject resultJson = (JSONObject) JSONObject.toJSON(vehicleJson);
        resultJson.put("data", vehJSON);
        return resultJson.toString();
    }
}
