package com.hikcreate.update_hbase.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.hikcreate.update_hbase.Repo.VioRepository;
import com.hikcreate.update_hbase.dao.BokanMapper;
import com.hikcreate.update_hbase.entity.KafkaJson;
import com.hikcreate.update_hbase.entity.Vio;
import com.hikcreate.update_hbase.service.VioEsService;
import com.hikcreate.update_hbase.utils.DateUtil;
import com.hikcreate.update_hbase.utils.EsUtils;
import com.hikcreate.update_hbase.utils.HbaseEntityUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.*;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Service("vioEsServiceImpl")
public class VioEsServiceImpl implements VioEsService {


    @Autowired
    private BokanMapper bokanDao;
    @Value("${app.kafka.vioDel}")
    private String vioDelTopic;
    @Autowired
    private KafkaTemplate kafkaTemplate;
    @Autowired
    private VioRepository vioRepository;

    @Value("${app.kafka.vio.topic}")
    private String vioTopic;


    @Value("${hbase.vio.table}")
    private String vioTableStr;
    @Value("${hbase.vio_index.table}")
    private String vioIndexTableStr;
    @Autowired
    private EsUtils esUtils;
    @Value("${hbase.zookeeper.property.clientPort}")
    private String hbaseAddress;
    @Value("${hbase.zookeeper.quorum}")
    private String hbaseZkQuorum;
    @Value("${hbase.master}")
    private String hbaseMaster;

    private static Logger logger = LoggerFactory.getLogger(VioEsServiceImpl.class);

    private void insertVio(Vio vio) {
        Optional<Vio> byId = vioRepository.findById(vio.getId());
        if (byId.isPresent()) {
            Vio vio1 = byId.get();
            if (!(vio1.getGxsj().substring(0, 19).compareTo(vio.getGxsj().substring(0, 19)) < 0)) {
                return;
            }
            //有驾驶人的数据不能被无驾驶人的数据覆盖掉
            if (vio1.getJszh() != null && vio.getJszh() != null && vio.getJszh().length() < 5 && vio1.getJszh().length() > 5) {
                return;
            }
        }
        vioRepository.save(vio);
    }


    @Override
    public void getHisVioToEs(String start, String end) {
        List<Vio> vios = bokanDao.getIncreVio(start + " 00:00:00", end + " 00:00:00");
        List<Vio> surveils = bokanDao.getIncreSurveil(start + " 00:00:00", end + " 00:00:00");
        logger.info("长度:" + vios.size() + "==================" + surveils.size());
        for (Vio vio : surveils) {
            insertVio(vio);
        }
        for (Vio vio : vios) {
            insertVio(vio);
        }
    }


    /**
     * 同步昨天的违法数据
     * @param finalI
     */
    @Override
    public void toEsPastDay(int finalI) {
        List<Vio> surveils = bokanDao.getIncreSurveilVm(DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI)) + " 00:00:00",
                DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI + 1)) + " 00:00:00");
        List<Vio> vios = bokanDao.getIncreVioVm(DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI)) + " 00:00:00",
                DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI + 1)) + " 00:00:00");
        logger.info("长度:" + vios.size() + "==================" + surveils.size());
        Table vioTable = null;
        Table vioIndexTable = null;
        org.apache.hadoop.hbase.client.Connection hbaseConn = null;
        try {
            hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
            vioTable = esUtils.getHbaseTable(hbaseConn, vioTableStr);
            vioIndexTable = esUtils.getHbaseTable(hbaseConn, vioIndexTableStr);
            for (Vio vio : surveils) {
                insertVio(vio);
                inserHbase(vio, vioTable, vioIndexTable);
            }
            for (Vio vio : vios) {
                insertVio(vio);
                inserHbase(vio, vioTable, vioIndexTable);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            esUtils.closeHbaseTable(vioTable);
            esUtils.closeHbaseTable(vioIndexTable);
            esUtils.closeHbaseCon(hbaseConn);
        }

        logger.info("end toEsPastDay");
    }

    /**
     * 插入数据进hbase
     *
     * @param vio
     * @param vioTable
     * @param vioIndexTable
     */
    private void inserHbase(Vio vio, Table vioTable, Table vioIndexTable) throws Exception {
        String rowkey = vio.getId();
        Get get = new Get(rowkey.getBytes());
        get.addColumn(Bytes.toBytes("useful"), Bytes.toBytes("gxsj"));
        get.setCheckExistenceOnly(true);
        Result result = vioTable.get(get);
        if (result.size() > 0) {
            for (Cell cell : result.rawCells()) {
                String colName = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                if ("gxsj".equals(colName) && value.length() > 18 && vio.getGxsj().length() > 18
                        && !(vio.getGxsj().substring(0, 19).compareTo(value.substring(0, 19)) > 0)) {
                    return;
                }
            }
        }
        Put put = new Put(rowkey.getBytes());
        put = HbaseEntityUtil.getHbaseEntityPut(vio, put);
        vioTable.put(put);
        String rowkey1 = vio.getJszh() + "#" + vio.getWfsj() + "#" + vio.getWfxw();
        Put put1 = new Put(rowkey1.getBytes());
        put1.addColumn("key_fam".getBytes(), "key".getBytes(), rowkey.getBytes());
        vioIndexTable.put(put1);
        String json = getJsonString(vio, rowkey, (vio.getJszh() == null ? "null" : vio.getJszh()) + "#" +
                (vio.getWfsj() == null ? "null" : vio.getWfsj()) + "#" + (vio.getWfxw() == null ? "null" : vio.getWfxw()));
        kafkaTemplate.send(vioTopic, json);
    }

    private String getJsonString(Object obj, String rowkey, String row_index) {
        JSONObject json = (JSONObject) JSONObject.toJSON(obj);
        JSONObject vehJSON = new JSONObject();
        for (Map.Entry<String, Object> entry : json.entrySet()) {
            String key = entry.getKey();
            vehJSON.put(key.substring(key.indexOf(":") + 1), entry.getValue());
        }

        KafkaJson vehicleJson = new KafkaJson();
        vehicleJson.setRow(rowkey);
        vehicleJson.setRow_index(row_index);
        JSONObject resultJson = (JSONObject) JSONObject.toJSON(vehicleJson);
        resultJson.put("data", vehJSON);
        return resultJson.toString();
    }

    @Override
    public void getHisVioToEsByTable(String start, String end, String table) {
        List<Vio> vios = null;
        if (table.contains("VIO_SURVEIL")) {
            vios = bokanDao.getIncreSurveilByTable("'" + start + " 00:00:00" + "'", "'" + end + " 00:00:00" + "'", table);
        } else if (table.contains("VIO_VIOLATION")) {
            vios = bokanDao.getIncreVioByTable("'" + start + " 00:00:00" + "'", "'" + end + " 00:00:00" + "'", table);
        } else {
            return;
        }
        for (Vio vio : vios) {
            insertVio(vio);
        }
    }

    @Override
    public void getHisVioToEsByHphm(String start, String end, String table, String hphm) {
        List<Vio> vios = null;
        if (table.contains("VIO_SURVEIL")) {
            vios = bokanDao.getIncreSurveilByTableAndHphm("'" + start + " 00:00:00" + "'", "'" + end + " 00:00:00" + "'", table,"'"+hphm+"'");
        } else if (table.contains("VIO_VIOLATION")) {
            vios = bokanDao.getIncreVioByTableAndHphm("'" + start + " 00:00:00" + "'", "'" + end + " 00:00:00" + "'", table,"'"+hphm+"'");
        } else {
            return;
        }
        for (Vio vio : vios) {
            insertVio(vio);
        }
    }


    /**
     * 违法删除表
     *
     * @param start
     * @param end
     * @param table
     */
    @Override
    public void vioDelHisRange(String start, String end, String table) {
        List<Vio> vios = null;
        if (table.contains("VIO_SURVEIL")) {
            vios = bokanDao.vioSureilDelHisRange("'" + start + " 00:00:00" + "'", "'" + end + " 00:00:00" + "'", table);
        } else if (table.contains("VIO_VIOLATION")) {
            vios = bokanDao.getIncreVioByTable("'" + start + " 00:00:00" + "'", "'" + end + " 00:00:00" + "'", table);
        } else {
            return;
        }
        Table vioTable = null;
        Table vioIndexTable = null;
        if (vios != null) {
            try {
                org.apache.hadoop.hbase.client.Connection hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
                vioTable = esUtils.getHbaseTable(hbaseConn, vioTableStr);
                vioIndexTable = esUtils.getHbaseTable(hbaseConn, vioIndexTableStr);
                for (Vio vio : vios) {
                    vioRepository.delete(vio);
                    vioIndexTable.delete(new Delete((vio.getJszh() + "#" + vio.getWfsj() + "#" + vio.getWfxw()).getBytes()));
                    vioTable.delete(new Delete(vio.getId().getBytes()));
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                esUtils.closeHbaseTable(vioTable);
                esUtils.closeHbaseTable(vioIndexTable);
            }

        }
        logger.info("end vioDelHisRange");
    }

    /**
     * 违法删除数据每天同步
     */
    @Override
    public void vioDelDay() {
        List<Vio> vios = null;
        String start = DateUtil.formatDate(DateUtil.getPastDate(new Date(), -20));
        String end = DateUtil.getDate();
        vios = bokanDao.vioSureilDelHisRange("'" + start + " 00:00:00" + "'", "'" + end + " 00:00:00" + "'", "ZCKJ.VM_VIO_SURVEIL_DEL");
        vios.addAll(bokanDao.getIncreVioByTable("'" + start + " 00:00:00" + "'", "'" + end + " 00:00:00" + "'", "ZCKJ.VM_VIO_VIOLATION_DEL"));
        Table vioTable = null;
        Table vioIndexTable = null;
        if (vios != null) {
            try {
                org.apache.hadoop.hbase.client.Connection hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
                vioTable = esUtils.getHbaseTable(hbaseConn, vioTableStr);
                vioIndexTable = esUtils.getHbaseTable(hbaseConn, vioIndexTableStr);
                for (Vio vio : vios) {
                    vioRepository.delete(vio);
                    vioIndexTable.delete(new Delete((vio.getJszh() + "#" + vio.getWfsj() + "#" + vio.getWfxw()).getBytes()));
                    vioTable.delete(new Delete(vio.getId().getBytes()));
                    JSONObject resultJson = new JSONObject();
                    resultJson.put("jszh", vio.getJszh() == null ? "null" : vio.getJszh());
                    resultJson.put("hphm", vio.getHphm() == null ? "null" : vio.getHphm());
                    resultJson.put("hpzl", vio.getHpzl() == null ? "null" : vio.getHpzl());
                    kafkaTemplate.send(vioDelTopic, resultJson.toString());
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                esUtils.closeHbaseTable(vioTable);
                esUtils.closeHbaseTable(vioIndexTable);
            }
        }
        logger.info("end vioDelDay");
    }


}
