package com.hikcreate.update_hbase.service.impl;


import com.hikcreate.update_hbase.entity.IndexHtable;
import com.hikcreate.update_hbase.utils.ConnectUtil;
import com.hikcreate.update_hbase.utils.HbaseUtil;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;


@Component
public class VioIndexServiceImpl implements com.hikcreate.update_hbase.service.VioIndexService {
    @Autowired
    private ConnectUtil connectUtil;
    @Value("${listVioIndexAll.sql}")
    private String listVioIndexAll_sql;
    @Value("${listVioIndexYesterday.sql}")
    private String listVioIndexYesterday_sql;
    @Autowired
    private HbaseUtil hbaseUtil;
    private static Logger logger = LoggerFactory.getLogger(VioIndexServiceImpl.class);

    @Override
    public void listVioIndexAll() {

        List<IndexHtable> indexHtables = null;
        try {
            logger.info("start query -->>  " + listVioIndexAll_sql);
            indexHtables = selectVio(listVioIndexAll_sql);
        } catch (SQLException e) {
            e.printStackTrace();
        }
        List<Put> puts = new ArrayList<>();
        logger.info("getting List<IndexHtable>");
        if (indexHtables != null && indexHtables.size() > 0) {
            for (IndexHtable indexHtable : indexHtables) {
                Put put = new Put(Bytes.toBytes(indexHtable.getRowkey()));
                put.addColumn(Bytes.toBytes("key_fam"), Bytes.toBytes(indexHtable.getCol()), Bytes.toBytes(indexHtable.getValue()));
                puts.add(put);
            }
            logger.info("get List<vio_index> Success");
        }

        try {
            logger.info("Starting put List<vio_index> to Hbase");
            hbaseUtil.addPuts("vio:vio_index", puts);
            logger.info("Put vio:vio_index  全表 Success");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    @Override
    public void listVioIndexYesterday() {
        List<IndexHtable> indexHtables = null;
        try {
            logger.info("start query -->>  " + listVioIndexYesterday_sql);
            indexHtables = selectVio(listVioIndexYesterday_sql);
            logger.info("query success");
        } catch (SQLException e) {
            e.printStackTrace();
        }
        List<Put> puts = new ArrayList<>();
        logger.info("getting List<IndexHtable>");
        if (indexHtables != null && indexHtables.size() > 0) {
            for (IndexHtable indexHtable : indexHtables) {
                Put put = new Put(Bytes.toBytes(indexHtable.getRowkey()));
                put.addColumn(Bytes.toBytes("key_fam"), Bytes.toBytes(indexHtable.getCol()), Bytes.toBytes(indexHtable.getValue()));
                puts.add(put);
            }
            logger.info("get List<vio_index> Success");
        }

        try {
            logger.info("Starting put List<vio_index> to Hbase");
            hbaseUtil.addPuts("vio:vio_index", puts);
            logger.info("Put vio:vio_index  天表  Success");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    //查违法vio_vioaltion表
    private List<IndexHtable> selectVio(String sql) throws SQLException {
        Connection connection = connectUtil.getConnect();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        ResultSet resultSet = preparedStatement.executeQuery();
        List<IndexHtable> Indexlist = new ArrayList<>();
        while (resultSet.next()) {
            IndexHtable indexHtable = new IndexHtable();
            indexHtable.setCol(resultSet.getString("col"));
            indexHtable.setRowkey(resultSet.getString("rowkey"));
            indexHtable.setValue(resultSet.getString("value"));
            Indexlist.add(indexHtable);
        }
        ConnectUtil.close(preparedStatement);
        ConnectUtil.close(connection);
        return Indexlist;
    }


}
