package com.hikcreate.update_hbase.service.impl;

import com.hikcreate.update_hbase.Repo.ViolationEs;
import com.hikcreate.update_hbase.Repo.ViolationRepository;
import com.hikcreate.update_hbase.dao.ViolationMapper;
import com.hikcreate.update_hbase.entity.Violation;
import com.hikcreate.update_hbase.service.ViolationService;
import com.hikcreate.update_hbase.utils.DateUtil;
import com.hikcreate.update_hbase.utils.EsUtils;
import com.hikcreate.update_hbase.utils.HbaseEntityUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.*;





@Component
public class ViolationServiceImpl implements ViolationService {

    @Autowired
    private ViolationMapper violationMapper;
    @Autowired
    private ViolationEs violationEs;
    @Autowired
    private ViolationRepository violationRepository;
    @Value("${hbase.es.violation}")
    private String hbaseTableStr;
    @Autowired
    private EsUtils esUtils;
    @Value("${hbase.zookeeper.property.clientPort}")
    private String hbaseAddress;
    @Value("${hbase.zookeeper.quorum}")
    private String hbaseZkQuorum;


    @Override
    public void imDataOracle2EsById(String... ids) {
        System.out.println(Arrays.toString(ids));
        List<Violation> list = violationMapper.getViolationById(Arrays.asList(ids));
        System.out.println("list size:"+list.size());
        for (Violation violation : list) {
            violationEs.save(violation);
        }
    }
    /**
     * 同步指定时间段的violation数据：vm_vio_violation,vm_vio_violation_his,vm_vio_violation_del,vio_violation
     */
    @Override
    public void violationDay(int len) {
        for (int i = 0; i < len; i++) {
            int finalI = i;
            new Thread(() -> {
                try {
                    List<Violation> vmList = violationMapper.getVmViolation(DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI)), DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI + 1)));
                    List<Violation> list = violationMapper.getViolation(DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI)), DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI + 1)));
                    List<Violation> vmHisList = violationMapper.getVmViolationHis(DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI)), DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI + 1)));
                    List<Violation> vmDelList = violationMapper.getVmViolationDel(DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI)), DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI + 1)));
                    List<Violation> finalList = new ArrayList<>();
                    finalList.addAll(vmList);
                    finalList.addAll(list);
                    finalList.addAll(vmHisList);
                    finalList.addAll(vmDelList);
                    org.apache.hadoop.hbase.client.Connection hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
                    Table violationTable = hbaseConn.getTable(TableName.valueOf(hbaseTableStr));
                    for (Violation violation : finalList) {
                        Optional<Violation> byId = violationRepository.findById(violation.getWfbh());
                        if (byId.isPresent() && byId.get().getGxsj().compareTo(violation.getGxsj()) >= 0) {
                            continue;
                        } else {
                            violationRepository.save(violation);
                            Put put = new Put(violation.getWfbh().getBytes());
                            put = HbaseEntityUtil.getHbaseEntityPutNoPrefix(violation, put);
                            violationTable.put(put);
                        }
                    }
                    esUtils.closeHbaseTable(violationTable);
                    esUtils.closeHbaseCon(hbaseConn);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        }


    }

    /**
     *指定时间段同步到violation数据到es
     */
   @Override
    public  void insertViolation2EsByDte(String start,String end) {
               try {
                   List<Violation> list = violationMapper.getVmViolation(start, end);
                   violationRepository.saveAll(list);
                   /*for (Violation violation : list) {
                       Optional<Violation> byId = violationRepository.findById(violation.getWfbh());
                       if (byId.isPresent() && byId.get().getGxsj().compareTo(violation.getGxsj()) >= 0) {
                           continue;
                       } else {
                           violationRepository.save(violation);
                       }
                   }*/
               } catch (Exception e) {
                   e.printStackTrace();
               }
   }

    /**
     * 同步小数据量表到Es的现场违法表：vio_violation,vm_vio_violation_del
     */
    @Override
    public void sysViolationSmallData() {
        //vio_violation
        for (int i = 1; i < 16; i++) {
            int finalI = i;
            new Thread(() -> {
                try {
                    List<Violation> list = violationMapper.getViolation(DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI)), DateUtil.formatDate(DateUtil.getPastDate(new Date(), -finalI + 1)));
                    org.apache.hadoop.hbase.client.Connection hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
                    Table violationTable = hbaseConn.getTable(TableName.valueOf(hbaseTableStr));
                    for (Violation violation : list) {
                        Optional<Violation> byId = violationRepository.findById(violation.getWfbh());
                        if (byId.isPresent() && byId.get().getGxsj().compareTo(violation.getGxsj()) >= 0) {
                            continue;
                        } else {
                            violationRepository.save(violation);
                            Put put = new Put(violation.getWfbh().getBytes());
                            put = HbaseEntityUtil.getHbaseEntityPutNoPrefix(violation, put);
                            violationTable.put(put);
                        }
                    }
                    esUtils.closeHbaseTable(violationTable);
                    esUtils.closeHbaseCon(hbaseConn);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        }
        //vm_vio_violation_del
        try {
            List<Violation> vmDelList = violationMapper.getViolationDelAll();
            org.apache.hadoop.hbase.client.Connection hbaseConn = esUtils.getHbseCon(hbaseAddress, hbaseZkQuorum);
            Table violationTable = hbaseConn.getTable(TableName.valueOf(hbaseTableStr));
            for (Violation violation : vmDelList) {
                Optional<Violation> byId = violationRepository.findById(violation.getWfbh());
                if (byId.isPresent() && byId.get().getGxsj().compareTo(violation.getGxsj()) >= 0) {
                    continue;
                } else {
                    violationRepository.save(violation);
                    Put put = new Put(violation.getWfbh().getBytes());
                    put = HbaseEntityUtil.getHbaseEntityPutNoPrefix(violation, put);
                    violationTable.put(put);
                }
            }
            esUtils.closeHbaseTable(violationTable);
            esUtils.closeHbaseCon(hbaseConn);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
