package com.hikcreate.update_hbase.utils;

import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class EsConfig {

    public TransportClient client(String hosts,Integer port,String clusterName) throws UnknownHostException {

        Settings settings = Settings.builder().put("cluster.name", clusterName)
                .put("client.transport.sniff", true).build();

        TransportClient client = new PreBuiltTransportClient(settings);

        String[] split = hosts.split(",");
        for(String str:split){
            client.addTransportAddress(new TransportAddress(InetAddress.getByName(str), port));
        }

        return client;

    }
}
