package com.hikcreate.update_hbase.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hikcreate.update_hbase.redis.RedisUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.*;
import org.apache.hadoop.hbase.util.Bytes;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;


import java.io.IOException;
import java.util.Map;
import java.util.Set;

@Component
public class EsUtils {

    @Autowired
    private KafkaTemplate kafkaTemplate;

    private static Logger logger = LoggerFactory.getLogger(EsUtils.class);


    private static XContentBuilder getObjXcont(JSONObject jsonObject) throws IOException {
        Set<Map.Entry<String, Object>> entries = jsonObject.entrySet();
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject();
        for (Map.Entry<String, Object> entry : entries) {
            xContentBuilder.field(entry.getKey(), (entry.getValue() == null ? "null" : entry.getValue()));
        }
        xContentBuilder.endObject();
        return xContentBuilder;
    }

    /**
     * 发送卡夫卡数据
     *
     * @param id
     * @param acdAll   新数据
     * @param acdAll1  旧数据
     * @param acdTopic
     */
    public void sendKafka(String id, Object acdAll, Object acdAll1, String acdTopic) {
        JSONObject resultJson = new JSONObject();
        resultJson.put("esid", id);
        JSONObject jsonObject = (JSONObject) JSONObject.toJSON(acdAll);
        resultJson.put("new_data", jsonObject);
        if (acdAll1 != null) {
            JSONObject acdAll1Json = (JSONObject) JSON.toJSON(acdAll1);
            resultJson.put("old_data", acdAll1Json);
        } else {
            resultJson.put("old_data", "");
        }
        kafkaTemplate.send(acdTopic, resultJson.toString());
    }



    public  String getGxsj(RedisUtil redisClient, String day, String keyName) {
        String updateTime;
        if (day == null) {
            updateTime = DateUtil.getDate() + " 05:30:00";
            if (redisClient.hasKey(keyName)) {
                updateTime = redisClient.get(keyName);
            }
        } else {
            updateTime = day;
        }
        return updateTime;
    }

    public  Connection getHbseCon(String hbaseAddress, String hbaseZkQuorum) throws IOException {
        Configuration hbaseConf = HBaseConfiguration.create();
        hbaseConf.set("hbase.zookeeper.property.clientPort", hbaseAddress);
        hbaseConf.set("hbase.zookeeper.quorum", hbaseZkQuorum);
        return ConnectionFactory.createConnection(hbaseConf);
    }

    public  Table getHbaseTable(Connection hbaseConn, String vehflowHbaseStr) throws IOException {
        return hbaseConn.getTable(TableName.valueOf(vehflowHbaseStr));
    }

    public  void closeHbaseTable(Table vehFlowTable) {
        if (vehFlowTable != null) {
            try {
                vehFlowTable.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }


    public  void closeHbaseCon(Connection hbaseConn) {
        if (hbaseConn != null) {
            try {
                hbaseConn.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * @param vehFlow  实体类
     * @param vehFlowTable   主表
     * @param vehFlowIndexTable  索引表
     * @param rowkey  主表rowkey
     * @param indexRowkey  索引表rowkey
     * @param col  索引表的列名
     * @param gxsj  更新时间
     * @param family  列族，现在主表和索引表列族一样，都是info
     */
    public  void insertHbaseTableVo(Object vehFlow, Table vehFlowTable, Table vehFlowIndexTable, String rowkey, String indexRowkey, String col, String gxsj, String family) {
        try {
            JSONObject jsonObject = (JSONObject) JSONObject.toJSON(vehFlow);
            //判断是否需要插入
            Get get = new Get(rowkey.getBytes());
            get.addColumn(Bytes.toBytes(family), Bytes.toBytes(gxsj));
            get.setCheckExistenceOnly(true);
            Result result = vehFlowTable.get(get);
            if (result.size() > 0) {
                for (Cell cell : result.rawCells()) {
                    String colName = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                    String value = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                    if (gxsj.equals(colName) && value.length() > 18 && ((String) jsonObject.get(gxsj)).length() > 18
                            && !(((String) jsonObject.get(gxsj)).substring(0, 19).compareTo(value.substring(0, 19)) > 0)) {
                        return;
                    }
                }
            }
            //插入数据
            Put put = new Put(rowkey.getBytes());
            Set<Map.Entry<String, Object>> entries = jsonObject.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                put.addColumn(family.getBytes(), entry.getKey().getBytes(), (entry.getValue() == null ? "null" : entry.getValue().toString()).getBytes());
            }
            vehFlowTable.put(put);
            //建立索引
            Put index_put = new Put(indexRowkey.getBytes());
            index_put.addColumn(family.getBytes(), ((String) jsonObject.get(col)).getBytes(), rowkey.getBytes());
            vehFlowIndexTable.put(index_put);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    public static void insertDrvFlowEs(Object drvFlow, TransportClient transportClient, String Index, String Type, String esid, String gsxj) {
        try {
            JSONObject jsonObject = (JSONObject) JSONObject.toJSON(drvFlow);
            //先判断是否存在
            GetResponse result1 = transportClient.prepareGet(Index, Type, (String) jsonObject.get(esid)).get();
            if (result1.getSource() != null) {
                if (!result1.getSource().containsKey(gsxj)) {
                    return;
                }
                String gxsj = (String) result1.getSource().get(gsxj);
                if (gxsj.length() > 18 && ((String) jsonObject.get(gsxj)).length() > 18
                        && !(gxsj.substring(0, 19).compareTo(((String) jsonObject.get(gsxj)).substring(0, 19)) < 0)) {
                    return;
                }
            }
            //需要插入ES
            XContentBuilder xContentBuilder = getObjXcont(jsonObject);
            IndexResponse result = transportClient.prepareIndex(Index, Type).
                    setId((String) jsonObject.get(esid))
                    .setSource(xContentBuilder).get();
            // logger.info("驾驶证业务流水drv_flow数据插入：" + result.getId());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
