package com.hikcreate.update_hbase.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.hadoop.hbase.client.Put;

import java.util.Map;
import java.util.Set;

public class HbaseEntityUtil {

    public static Put getHbaseEntityPut(Object o, Put put){
        JSONObject jsonObject = (JSONObject) JSONObject.toJSON(o);
        Set<Map.Entry<String, Object>> entries = jsonObject.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
//            System.out.println(entry.getKey().split(":")[0]+"---------"+entry.getKey().split(":")[1]+"--------"+entry.getValue().toString());
            if(entry.getKey().contains(":")){
                String[] split = entry.getKey().split(":");
                put.addColumn(split[0].getBytes(), split[1].getBytes(), (entry.getValue() == null ? "null" : entry.getValue().toString()).getBytes());
            }
        }
        return put;
    }

    public static Put getHbaseEntityPutNoPrefix(Object o, Put put) {
        JSONObject jsonObject = (JSONObject) JSONObject.toJSON(o);
        Set<Map.Entry<String, Object>> entries = jsonObject.entrySet();
        for (Map.Entry<String, Object> entry: entries) {
            put.addColumn("info".getBytes(), entry.getKey().getBytes(), (entry.getValue() == null ? "null" : entry.getValue().toString()).getBytes());
        }
        return put;
    }
}
