package com.hikcreate.update_hbase.utils;


import com.hikcreate.update_hbase.entity.DrvFlow;
import com.hikcreate.update_hbase.entity.IndexHtable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.*;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
public class HbaseUtil {
    private Connection conn;
    private String ZK_QUORUM = "hbase.zookeeper.quorum";
    private String ZK_CLIENT_PORT = "hbase.zookeeper.property.clientPort";
    private String HBASE_POS = "192.16.25.28";
    @Value("${ZK_POS}")
    private String ZK_POS;
    @Value("${ZK_PORT_VALUE}")
    private String ZK_PORT_VALUE;
    private Logger log = LoggerFactory.getLogger(HbaseUtil.class);

//    /*** 静态构造，在调用静态方法前运行，  初始化连接对象  * */
//    static {
//        Configuration conf = HBaseConfiguration.create();
//       // conf.set("hbase.rootdir", "hdfs://"+ HBASE_POS + ":9000/hbase");
//        conf.set(ZK_QUORUM, ZK_POS);
//        conf.set(ZK_CLIENT_PORT, ZK_PORT_VALUE);
//        //创建连接池
//
//            log.info("start create hbase connections........");
//        try {
//            conn = ConnectionFactory.createConnection(conf);
//            log.info("create hbase connections success");
//        } catch (IOException e) {
//            e.printStackTrace();
//            log.info("create hbase connections failed");
//        }
//    }

    private Connection init() {
        Configuration conf = HBaseConfiguration.create();
        conf.set(ZK_QUORUM, ZK_POS);
        conf.set(ZK_CLIENT_PORT, ZK_PORT_VALUE);
        //创建连接池
        log.info("start create hbase connections........");
        try {
            Connection conn = ConnectionFactory.createConnection(conf);
            log.info("create hbase connections success");
            return conn;
        } catch (IOException e) {
            log.info("create hbase connections failed");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public void addPuts(String tableName, List<Put> puts) throws IOException {
        conn = init();
        log.info("进行获取表……：" + tableName);
        Table table = conn.getTable(TableName.valueOf(tableName));
        log.info("获取表：" + tableName);
        log.info("批量put数据到表：" + tableName);
        for (Put put : puts) {
            table.put(put);
        }
        log.info(tableName + "批量数据已添加");
        table.close();
        conn.close();
    }

    //****************************1.  批量添加索引数据  *******************************
    public void addRows(String tableName, List<IndexHtable> indexHtables) throws IOException {
        HTable table = (HTable) conn.getTable(TableName.valueOf(tableName));
        for (IndexHtable indexHtable : indexHtables) {
            Put put = new Put(Bytes.toBytes(indexHtable.getRowkey()));
            put.addColumn(Bytes.toBytes("key_fam"), Bytes.toBytes(indexHtable.getCol()), Bytes.toBytes(indexHtable.getValue()));
            table.put(put);
        }
        log.info(tableName + "批量数据已添加");
        table.close();
        conn.close();
    }

//**************************** 2.  添加一条数据  *******************************

    public void addRow(String tableName, String rowKey, String columnFamily,
                       String column, String value) throws IOException {

        HTable table = (HTable) conn.getTable(TableName.valueOf(tableName));
        Put put = new Put(Bytes.toBytes(rowKey));  //   通过rowkey创建一个 put 对象
        //  在 put 对象中设置 列族、列、值
        put.addColumn(Bytes.toBytes(columnFamily), Bytes.toBytes(column), Bytes.toBytes(value));
        table.put(put);     //  插入数据，可通过 put(List<Put>) 批量插入
        table.close();
        conn.close();
    }

//  ***********************  3.  获取一条数据   *******************************

    public void getRow(String tableName, String rowKey) throws IOException {

        HTable table = (HTable) conn.getTable(TableName.valueOf(tableName));
        Get get = new Get(Bytes.toBytes(rowKey));   //  通过rowkey创建一个 get 对象
        Result result = table.get(get);         //  输出结果
        for (Cell cell : result.rawCells()) {
            System.out.println(
                    "\u884c\u952e:" + new String(CellUtil.cloneRow(cell)) + "\t" +
                            "\u5217\u65cf:" + new String(CellUtil.cloneFamily(cell)) + "\t" +
                            "\u5217\u540d:" + new String(CellUtil.cloneQualifier(cell)) + "\t" +
                            "\u503c:" + new String(CellUtil.cloneValue(cell)) + "\t" +
                            "\u65f6\u95f4\u6233:" + cell.getTimestamp());
        }
        table.close();
        conn.close();
    }

//  ***************************  4. 全表扫描  ****************************

    public void scanTable(String tableName) throws IOException {

        HTable table = (HTable) conn.getTable(TableName.valueOf(tableName));
        Scan scan = new Scan();  //  创建扫描对象
        ResultScanner results = table.getScanner(scan);   //  全表的输出结果
        for (Result result : results) {
            for (Cell cell : result.rawCells()) {
                System.out.println(
                        "\u884c\u952e:" + new String(CellUtil.cloneRow(cell)) + "\t" +
                                "\u5217\u65cf:" + new String(CellUtil.cloneFamily(cell)) + "\t" +
                                "\u5217\u540d:" + new String(CellUtil.cloneQualifier(cell)) + "\t" +
                                "\u503c:" + new String(CellUtil.cloneValue(cell)) + "\t" +
                                "\u65f6\u95f4\u6233:" + cell.getTimestamp());
            }
        }
        results.close();
        table.close();
        conn.close();
    }

    //**************************** 5. 删除一条数据  *****************************
    public void delRow(String tableName, String rowKey) throws IOException {

        HTable table = (HTable) conn.getTable(TableName.valueOf(tableName));
        Delete delete = new Delete(Bytes.toBytes(rowKey));
        table.delete(delete);
        table.close();
        conn.close();
    }

    //************************   6. 删除多条数据  *****************************
    public void delRows(String tableName, String[] rows) throws IOException {

        HTable table = (HTable) conn.getTable(TableName.valueOf(tableName));
        List<Delete> list = new ArrayList<>();
        for (String row : rows) {
            Delete delete = new Delete(Bytes.toBytes(row));
            list.add(delete);
        }
        table.delete(list);
        table.close();
        conn.close();
    }

    // ***************************  7. 删除列族  **************************
    public void delColumnFamily(String tableName, String columnFamily)
            throws IOException {

        HBaseAdmin hAdmin = (HBaseAdmin) conn.getAdmin();  // 创建数据库管理员
        hAdmin.deleteColumn(tableName, columnFamily);
        conn.close();
    }

// ***************************  8  删除数据库表  **********************

    public void deleteTable(String tableName) throws IOException {

        HBaseAdmin hAdmin = (HBaseAdmin) conn.getAdmin();   // 创建数据库管理员
        if (hAdmin.tableExists(tableName)) {
            hAdmin.disableTable(tableName);     //  失效表
            hAdmin.deleteTable(tableName);     //  删除表
            System.out.println("删除" + tableName + "表成功");
            conn.close();
        } else {
            System.out.println("需要删除的" + tableName + "表不存在");
            conn.close();
            System.exit(0);
        }
    }

// ***************************  9. 追加插入  ********************************

    // 在原有的value后面追加新的value，  "a" + "bc"  -->  "abc"
    public void appendData(String tableName, String rowKey, String columnFamily,
                           String column, String value) throws IOException {

        HTable table = (HTable) conn.getTable(TableName.valueOf(tableName));
        Append append = new Append(Bytes.toBytes(rowKey));
        append.add(Bytes.toBytes(columnFamily), Bytes.toBytes(column), Bytes.toBytes(value));
        table.append(append);
        table.close();
        conn.close();
    }

// *****************************  10  符合条件后添加数据  *****************************

    public boolean checkAndPut(String tableName, String rowKey,
                               String columnFamilyCheck, String columnCheck, String valueCheck,
                               String columnFamily, String column, String value) throws IOException {

        HTable table = (HTable) conn.getTable(TableName.valueOf(tableName));
        Put put = new Put(Bytes.toBytes(rowKey));
        put.addColumn(Bytes.toBytes(columnFamily), Bytes.toBytes(column), Bytes.toBytes(value));
        boolean result = table.checkAndPut(Bytes.toBytes(rowKey), Bytes.toBytes(columnFamilyCheck),
                Bytes.toBytes(columnCheck), Bytes.toBytes(valueCheck), put);
        table.close();
        conn.close();
        return result;
    }

// ****************************  11  符合条件后删除数据   ***************************

    public boolean checkAndDelete(String tableName, String rowKey,
                                  String columnFamilyCheck, String columnCheck, String valueCheck,
                                  String columnFamily, String column) throws IOException {

        HTable table = (HTable) conn.getTable(TableName.valueOf(tableName));
        Delete delete = new Delete(Bytes.toBytes(rowKey));
        delete.addColumn(Bytes.toBytes(columnFamilyCheck), Bytes.toBytes(columnCheck));
        boolean result = table.checkAndDelete(Bytes.toBytes(rowKey),
                Bytes.toBytes(columnFamilyCheck), Bytes.toBytes(columnCheck),
                Bytes.toBytes(valueCheck), delete);
        table.close();
        conn.close();
        return result;
    }

//***********************  // 11 计数器  ***********************************

    public long incrementColumnValue(String tableName, String rowKey,
                                     String columnFamily, String column, long amount) throws IOException {

        HTable table = (HTable) conn.getTable(TableName.valueOf(tableName));
        long result = table.incrementColumnValue(Bytes.toBytes(rowKey),
                Bytes.toBytes(columnFamily), Bytes.toBytes(column), amount);
        table.close();
        conn.close();
        return result;
    }

    //***********************  // 12 获取列族下所有列名  ***********************************
    public ArrayList<String> getcolnames(String rowkey, String tablename, String colf) throws IOException {
        Get get = new Get(Bytes.toBytes(rowkey));
        ArrayList<String> cols = new ArrayList<>();
        Table table = conn.getTable(TableName.valueOf(tablename));
        Result result = table.get(get);
        Map<byte[], byte[]> familyMap = result.getFamilyMap(Bytes.toBytes(colf));
        for (Map.Entry<byte[], byte[]> entry : familyMap.entrySet()) {
            cols.add(Bytes.toString(entry.getKey()));
            System.out.println(Bytes.toString(entry.getKey()));
        }
        return cols;
    }


    //****************************2.  批量添加机动车业务流水索引数据/基本信息数据  *******************************
    public void addDrvFlowAndIndex(String tableName, String indexTableNmae, List<DrvFlow> drvFlows) throws IOException {
        conn = init();
        HTable table = (HTable) conn.getTable(TableName.valueOf(tableName));
        HTable indexTable = (HTable) conn.getTable(TableName.valueOf(indexTableNmae));
        for (DrvFlow drvFlow : drvFlows) {
            //拼接索引表信息并存入hbase
            Put put = new Put(Bytes.toBytes(drvFlow.getSfzmhm()));
            put.addColumn(Bytes.toBytes("key_fam"), Bytes.toBytes(drvFlow.getKssj() + "#" + drvFlow.getYwlx()), Bytes.toBytes(drvFlow.getLsh()));
            indexTable.put(put);
            //拼接基本流水信息存入hbase
            Put put1 = new Put(Bytes.toBytes(drvFlow.getLsh()));
            put1 = HbaseEntityUtil.getHbaseEntityPut(drvFlow, put1);
            table.put(put1);
        }
        log.info(tableName + "批量数据已添加");
        log.info(indexTableNmae + "批量数据已添加");
        table.close();
        indexTable.close();
        conn.close();
    }

    public void addDrvFlowAndIndex(String tableName, String indexTableNmae, DrvFlow drvFlow) throws IOException {
        conn = init();
        HTable table = (HTable) conn.getTable(TableName.valueOf(tableName));
        HTable indexTable = (HTable) conn.getTable(TableName.valueOf(indexTableNmae));
        //拼接索引表信息并存入hbase
        Put put = new Put(Bytes.toBytes(drvFlow.getSfzmhm()));
        put.addColumn(Bytes.toBytes("key_fam"), Bytes.toBytes(drvFlow.getKssj() + "#" + drvFlow.getYwlx()), Bytes.toBytes(drvFlow.getLsh()));
        indexTable.put(put);
        //拼接基本流水信息存入hbase
        Put put1 = new Put(Bytes.toBytes(drvFlow.getLsh()));
        put1 = HbaseEntityUtil.getHbaseEntityPutNoPrefix(drvFlow, put1);
        table.put(put1);
//        log.info(tableName + "批量数据已添加");
//        log.info(indexTableNmae + "批量数据已添加");
        table.close();
        indexTable.close();
        conn.close();
    }

    public void addDrvFlowAndIndex(Table tableName, Table indexTableNmae, DrvFlow drvFlow) throws IOException {
        //拼接索引表信息并存入hbase
        Put put = new Put(Bytes.toBytes(drvFlow.getSfzmhm()));
        put.addColumn(Bytes.toBytes("key_fam"), Bytes.toBytes(drvFlow.getKssj() + "#" + drvFlow.getYwlx()), Bytes.toBytes(drvFlow.getLsh()));
        indexTableNmae.put(put);
        //拼接基本流水信息存入hbase
        Put put1 = new Put(Bytes.toBytes(drvFlow.getLsh()));
        put1 = HbaseEntityUtil.getHbaseEntityPutNoPrefix(drvFlow, put1);
        tableName.put(put1);
        //log.info(tableName + "批量数据已添加");
        //log.info(indexTableNmae + "批量数据已添加");
//        log.info(tableName + "批量数据已添加");
//        log.info(indexTableNmae + "批量数据已添加");
        tableName.close();
        indexTableNmae.close();
    }


    //****************************3.  只批量添加机动车业务流水索引数据  *******************************
    public void addDrvFlowIndex(String indexTableNmae, List<DrvFlow> drvFlows) throws IOException {
        conn = init();
        HTable indexTable = (HTable) conn.getTable(TableName.valueOf(indexTableNmae));
        for (DrvFlow drvFlow : drvFlows) {
            //拼接索引表信息并存入hbase
            Put put = new Put(Bytes.toBytes(drvFlow.getSfzmhm()));
            put.addColumn(Bytes.toBytes("key_fam"), Bytes.toBytes(drvFlow.getKssj() + "#" + drvFlow.getYwlx()), Bytes.toBytes(drvFlow.getLsh()));
            indexTable.put(put);
        }
        log.info(indexTableNmae + "批量数据已添加");
        indexTable.close();
        conn.close();
    }

    //****************************传入hbase查询结果值，返回实体对象  *******************************


}
