package com.hikcreate.update_hbase.utils;

import org.apache.commons.lang3.StringUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlateNumUtil {
    /**
     *  使用正则表达式过滤非数字字符串
     * @param plateNum 需要过滤的字符串
     * @return
     */
    public static String filterUnNumber(String plateNum) {
        // 只允数字
        String regEx = "[^0-9]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(plateNum);
        //把非数字的字符替换为""
        return m.replaceAll("").trim();
    }

    /**
     * 根据字符串获取周几限号
     * @param numb
     * @return
     */
    public static int getDay(String numb) {
        if (StringUtils.isEmpty(numb)) {
            return 0;
        }
        int result = Integer.parseInt(numb.substring(numb.length() - 1));

        if (result == 0) {
            result = 5;
        }
        if (result > 5) {
            result = result - 5;
        }
        return result;
    }

}
