package com.hikcreate.update_hbase.utils;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author MOUBK
 * @create 2019/8/5 15:32
 */
public class Utils {
    private Utils() {
    }

    public static Date string2DateTime(String str) {
        if (str == null || str.trim().equals("") || str.equalsIgnoreCase("null")) {
            return null;

        }
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return format.parse(str);
        } catch (ParseException e) {
        }
        return null;
    }

    public static Date string2DateTime1(String str) {
        if (str == null || str.trim().equals("") || str.equalsIgnoreCase("null")) {
            return null;

        }
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        try {
            return format.parse(str);
        } catch (ParseException e) {
        }
        return null;
    }

    public static Date string2DateTime2(String str) {
        if (str == null || str.trim().equals("") || str.equalsIgnoreCase("null")) {
            return null;

        }
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        try {
            return format.parse(str);
        } catch (ParseException e) {
        }
        return null;
    }

    public static Integer string2Integer(String str) {
        return string2Integer(str, null);
    }

    public static Integer string2Integer(String str, Integer defaultValue) {
        if (str == null || str.trim().equals("") || str.equalsIgnoreCase("null")) {
            return defaultValue;
        }
        return Integer.parseInt(str);
    }

    public static BigDecimal string2BigDecimal(String str) {
        if (str != null) {
            try {
                return new BigDecimal(str);
            } catch (Exception e) {
            }
        }
        return null;
    }

    public static Long string2Long(String str) {
        if (str == null || str.trim().equals("") || str.equalsIgnoreCase("null")) {
            return null;
        }
        return Long.parseLong(str);
    }
}
