# _*_ coding:utf-8 _*_
_author_ = 'wenxin'
_date_ = '2020/6/11 11:03'
import requests
import allure
import pytest
import sys
import os

sys.path.append('../')
import logging
import datetime
from common import getSourceId
from common.getData import DoExcelByPandas

dt = datetime.datetime.now().strftime('%Y-%m-%d')
logging.basicConfig(level=logging.DEBUG,  # 控制台打印的日志级别
                    filename=os.path.join('../log', str(dt) + '.log'),  # 定义保存日志的路径，使用os.path.join()方法拼接文件路径，其展现为层级关系
                    filemode='a',  # 模式，有w和a，w就是写模式，每次都会重新写日志，覆盖之前的日志
                    # a是追加模式，默认如果不写的话，就是追加模式
                    format=
                    '%(asctime)s - %(pathname)s[line:%(lineno)d] - %(levelname)s: %(message)s'
                    # 日志格式
                    )

@allure.feature('数据源')
class TestSource():

    parametrize = DoExcelByPandas().get_data_for_pytest('../data/DataA_Source.xlsx', 'Sheet1')
    @allure.title('{title}')
    # @allure.severity('{severity}')
    @pytest.mark.parametrize('id,url,data,title,method,severity,condition,except_result', parametrize)
    def test(self, id, url, data, title, method, severity, condition, except_result):  # test开头的测试函数
        # 测试删除数据源接口
        if title == '删除mysql数据源' or title == '删除oracle数据源':
            id = getSourceId.get_SourceId(data)
            # 将数据源id拼接在url地址上
            url = url + id
            r = requests.post(url=url)
        # 测试需要传递dataSourceId的接口
        elif 'dataSourceId' in title:
            id = getSourceId.get_SourceId(data)
            url = url + id
            r = requests.get(url=url)
        # 测试post接口
        elif method == 'post':
            json = eval(data)  # eval返回传入字符串的表达式的结果
            r = requests.post(url=url, json=json)
        # 测试get接口
        elif method == 'get':
            r = requests.get(url=url)
        response = r.json()
        # print (type(response[condition]))
        assert response[condition] == str(except_result)

if __name__ == '__main__':
    pytest.main(['-s', 'test_Source.py'])  # -s参数是为了显示用例的打印信息。 -q参数只显示结果，不显示过程
